/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.aws.runtime;

import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.hibernate.search.orm.elasticsearch.aws.runtime.HibernateSearchOrmElasticsearchAwsRuntimeConfig;
import io.quarkus.hibernate.search.orm.elasticsearch.aws.runtime.HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit;
import io.quarkus.hibernate.search.orm.elasticsearch.runtime.HibernateSearchConfigUtil;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.function.BiConsumer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@Recorder
public class HibernateSearchOrmElasticsearchAwsRecorder {
    public HibernateOrmIntegrationRuntimeInitListener createRuntimeInitListener(HibernateSearchOrmElasticsearchAwsRuntimeConfig runtimeConfig, String persistenceUnitName) {
        HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit puConfig = runtimeConfig.persistenceUnits().get(persistenceUnitName);
        if (puConfig == null) {
            return null;
        }
        return new RuntimeInitListener(puConfig);
    }

    private static final class RuntimeInitListener
    implements HibernateOrmIntegrationRuntimeInitListener {
        private final HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit runtimeConfig;

        private RuntimeInitListener(HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
        }

        public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
            for (Map.Entry<String, HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig> backendEntry : this.runtimeConfig.backends().entrySet()) {
                this.contributeBackendRuntimeProperties(propertyCollector, backendEntry.getKey(), backendEntry.getValue());
            }
        }

        private void contributeBackendRuntimeProperties(BiConsumer<String, Object> propertyCollector, String backendName, HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit.ElasticsearchBackendRuntimeConfig elasticsearchBackendConfig) {
            Object configKeyRoot;
            HibernateSearchOrmElasticsearchAwsRuntimeConfigPersistenceUnit.ElasticsearchBackendAwsConfig aws = elasticsearchBackendConfig.aws();
            if (aws == null || !aws.signing().enabled()) {
                return;
            }
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, (String)backendName, (String)"aws.signing.enabled", (Object)true);
            Object object = configKeyRoot = backendName == null ? "quarkus.hibernate-search-orm.elasticsearch" : "quarkus.hibernate-search-orm.elasticsearch.backends." + backendName;
            if (aws.region().isEmpty()) {
                String propertyKey = (String)configKeyRoot + ".aws.region";
                throw new RuntimeException("When AWS request signing is enabled, the AWS region needs to be defined via property '" + propertyKey + "'.");
            }
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, (String)backendName, (String)"aws.region", (Object)aws.region().get().id());
            AwsCredentialsProvider credentialProvider = aws.credentials().type().create(aws.credentials(), (String)configKeyRoot);
            HibernateSearchConfigUtil.addBackendConfig(propertyCollector, (String)backendName, (String)"aws.credentials.type", configurationPropertySource -> credentialProvider);
        }
    }
}

