/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.infinispan.embedded.runtime;

import io.quarkiverse.infinispan.embedded.runtime.InfinispanEmbeddedProducer;
import io.quarkiverse.infinispan.embedded.runtime.InfinispanEmbeddedRuntimeConfig;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCacheImpl;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCacheInfo;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCacheInfoBuilder;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCachesConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CacheManagerInfo;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.annotations.RelaxedValidation;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.logging.Logger;

@Recorder
public class InfinispanRecorder {
    private static final Logger Log = Logger.getLogger(InfinispanRecorder.class);
    private final RuntimeValue<InfinispanCachesConfig> infinispanCacheConfigRV;

    public InfinispanRecorder(RuntimeValue<InfinispanCachesConfig> infinispanCacheConfigRV) {
        this.infinispanCacheConfigRV = infinispanCacheConfigRV;
    }

    public BeanContainerListener configureInfinispan(@RelaxedValidation List<SerializationContextInitializer> initializers) {
        return container -> {
            InfinispanEmbeddedProducer instance = (InfinispanEmbeddedProducer)container.beanInstance(InfinispanEmbeddedProducer.class, new Annotation[0]);
            instance.setInitializers(initializers);
        };
    }

    public void configureRuntimeProperties(InfinispanEmbeddedRuntimeConfig infinispanEmbeddedRuntimeConfig) {
        InfinispanEmbeddedProducer iep = (InfinispanEmbeddedProducer)Arc.container().instance(InfinispanEmbeddedProducer.class, new Annotation[0]).get();
        iep.setRuntimeConfig(infinispanEmbeddedRuntimeConfig);
    }

    public Supplier<AdvancedCache> infinispanAdvancedCacheSupplier(final String cacheName) {
        return new InfinispanEmbeddedSupplier<AdvancedCache>(new Function<InfinispanEmbeddedProducer, AdvancedCache>(){

            @Override
            public AdvancedCache apply(InfinispanEmbeddedProducer infinispanEmbeddedProducer) {
                return infinispanEmbeddedProducer.getAdvancedCache(cacheName);
            }
        });
    }

    public Supplier<EmbeddedCacheManager> infinispanEmbeddedSupplier() {
        return new InfinispanEmbeddedSupplier<EmbeddedCacheManager>(new Function<InfinispanEmbeddedProducer, EmbeddedCacheManager>(){

            @Override
            public EmbeddedCacheManager apply(InfinispanEmbeddedProducer infinispanEmbeddedProducer) {
                return infinispanEmbeddedProducer.manager();
            }
        });
    }

    public CacheManagerInfo getCacheManagerSupplier() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && "infinispan".equals(context.cacheType());
            }

            public Supplier<CacheManager> get(final CacheManagerInfo.Context context) {
                return new Supplier<CacheManager>(){

                    @Override
                    public CacheManager get() {
                        Set<InfinispanCacheInfo> cacheInfos = InfinispanCacheInfoBuilder.build(context.cacheNames(), (InfinispanCachesConfig)InfinispanRecorder.this.infinispanCacheConfigRV.getValue());
                        if (cacheInfos.isEmpty()) {
                            return new CacheManagerImpl(Collections.emptyMap());
                        }
                        HashMap<String, InfinispanCacheImpl> caches = new HashMap<String, InfinispanCacheImpl>(cacheInfos.size() + 1, 1.0f);
                        for (InfinispanCacheInfo cacheInfo : cacheInfos) {
                            if (Log.isDebugEnabled()) {
                                Log.debugf("Building Infinispan cache [%s] with [lifespan=%s], [maxIdle=%s]", (Object)cacheInfo.name, cacheInfo.lifespan, cacheInfo.maxIdle);
                            }
                            InfinispanCacheImpl cache = new InfinispanCacheImpl(cacheInfo);
                            caches.put(cacheInfo.name, cache);
                        }
                        return new CacheManagerImpl(caches);
                    }
                };
            }
        };
    }

    static final class InfinispanEmbeddedSupplier<T>
    implements Supplier<T> {
        private final Function<InfinispanEmbeddedProducer, T> producer;

        InfinispanEmbeddedSupplier(Function<InfinispanEmbeddedProducer, T> producer) {
            this.producer = producer;
        }

        @Override
        public T get() {
            InfinispanEmbeddedProducer infinispanEmbeddedProducer = (InfinispanEmbeddedProducer)Arc.container().instance(InfinispanEmbeddedProducer.class, new Annotation[0]).get();
            return this.producer.apply(infinispanEmbeddedProducer);
        }
    }
}

