/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.infinispan.embedded.runtime.cache;

import io.quarkiverse.infinispan.embedded.runtime.InfinispanEmbeddedProducer;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCacheInfo;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.cache.Cache;
import io.quarkus.cache.runtime.AbstractCache;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.NullValue;
import org.infinispan.commons.util.concurrent.CompletionStages;

public class InfinispanCacheImpl
extends AbstractCache
implements Cache {
    private final AdvancedCache cache;
    private final InfinispanCacheInfo cacheInfo;
    private final Map<Object, CompletableFuture> computationResults = new ConcurrentHashMap<Object, CompletableFuture>();
    private final long lifespan;
    private final long maxIdle;

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo, org.infinispan.Cache cache) {
        this(cacheInfo, cache.getAdvancedCache());
    }

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo, AdvancedCache cache) {
        this.cacheInfo = cacheInfo;
        this.cache = cache;
        this.lifespan = cacheInfo.lifespan.map(l -> l.toMillis()).orElse(-1L);
        this.maxIdle = cacheInfo.maxIdle.map(m -> m.toMillis()).orElse(-1L);
    }

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo) {
        this(cacheInfo, InfinispanCacheImpl.retrieveCache(cacheInfo.name));
    }

    private static AdvancedCache retrieveCache(String cacheName) {
        ArcContainer container = Arc.container();
        InfinispanEmbeddedProducer producer = (InfinispanEmbeddedProducer)container.instance(InfinispanEmbeddedProducer.class, new Annotation[0]).get();
        return producer.getAdvancedCache(cacheName);
    }

    public String getName() {
        return Objects.requireNonNullElse(this.cacheInfo.name, "default-infinispan-cache");
    }

    public Object getDefaultKey() {
        return "default-key";
    }

    private Object encodeNull(Object value) {
        return value != null ? value : NullValue.NULL;
    }

    private <T> T decodeNull(Object value) {
        return (T)(value != NullValue.NULL ? value : null);
    }

    public <K, V> Uni<V> get(K key, Function<K, V> valueLoader) {
        return Uni.createFrom().completionStage(() -> CompletionStages.handleAndCompose((CompletionStage)this.cache.getAsync(key), (v1, ex1) -> {
            if (ex1 != null) {
                return CompletableFuture.failedFuture(ex1);
            }
            if (v1 != null) {
                return CompletableFuture.completedFuture(this.decodeNull(v1));
            }
            CompletableFuture resultAsync = new CompletableFuture();
            CompletableFuture computedValue = this.computationResults.putIfAbsent(key, resultAsync);
            if (computedValue != null) {
                return computedValue;
            }
            Object newValue = valueLoader.apply(key);
            this.cache.putIfAbsentAsync(key, this.encodeNull(newValue), this.lifespan, TimeUnit.MILLISECONDS, this.maxIdle, TimeUnit.MILLISECONDS).whenComplete((existing, ex2) -> {
                if (ex2 != null) {
                    resultAsync.completeExceptionally((Throwable)ex2);
                } else if (existing == null) {
                    resultAsync.complete(newValue);
                } else {
                    resultAsync.complete(this.decodeNull(existing));
                }
                this.computationResults.remove(key);
            });
            return resultAsync;
        }));
    }

    public <K, V> Uni<V> getAsync(K key, Function<K, Uni<V>> valueLoader) {
        final Context context = Vertx.currentContext();
        return Uni.createFrom().completionStage(CompletionStages.handleAndCompose((CompletionStage)this.cache.getAsync(key), (v1, ex1) -> {
            if (ex1 != null) {
                return CompletableFuture.failedFuture(ex1);
            }
            if (v1 != null) {
                return CompletableFuture.completedFuture(this.decodeNull(v1));
            }
            CompletableFuture resultAsync = new CompletableFuture();
            CompletableFuture computedValue = this.computationResults.putIfAbsent(key, resultAsync);
            if (computedValue != null) {
                return computedValue;
            }
            ((Uni)valueLoader.apply(key)).convert().toCompletionStage().whenComplete((newValue, ex2) -> {
                if (ex2 != null) {
                    resultAsync.completeExceptionally((Throwable)ex2);
                    this.computationResults.remove(key);
                } else {
                    this.cache.putIfAbsentAsync(key, this.encodeNull(newValue), this.lifespan, TimeUnit.MILLISECONDS, this.maxIdle, TimeUnit.MILLISECONDS).whenComplete((existing, ex3) -> {
                        if (ex3 != null) {
                            resultAsync.completeExceptionally((Throwable)ex3);
                        } else if (existing == null) {
                            resultAsync.complete(newValue);
                        } else {
                            resultAsync.complete(this.decodeNull(existing));
                        }
                        this.computationResults.remove(key);
                    });
                }
            });
            return resultAsync;
        })).emitOn(new Executor(){

            @Override
            public void execute(final Runnable command) {
                Context ctx = Vertx.currentContext();
                if (context == null) {
                    if (ctx == null) {
                        command.run();
                    } else {
                        ((ContextInternal)ctx).duplicate().runOnContext((Handler)new Handler<Void>(){

                            public void handle(Void ignored) {
                                command.run();
                            }
                        });
                    }
                } else if (ctx == context) {
                    command.run();
                } else {
                    context.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void ignored) {
                            command.run();
                        }
                    });
                }
            }
        });
    }

    public Uni<Void> invalidate(Object key) {
        return Uni.createFrom().completionStage(() -> this.cache.removeAsync(key));
    }

    public Uni<Void> invalidateAll() {
        return Uni.createFrom().completionStage(() -> this.cache.clearAsync());
    }

    public Uni<Void> invalidateIf(Predicate<Object> predicate) {
        throw new UnsupportedOperationException("Not supported operation");
    }

    public <T extends Cache> T as(Class<T> type) {
        if (type.getTypeName().equals(InfinispanCacheImpl.class.getTypeName())) {
            return (T)((Object)this);
        }
        throw new IllegalArgumentException("Class type not supported : " + String.valueOf(type));
    }
}

