/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.infinispan.embedded.runtime.cache;

import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCacheInfo;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCacheRuntimeConfig;
import io.quarkiverse.infinispan.embedded.runtime.cache.InfinispanCachesConfig;
import io.quarkus.runtime.configuration.HashSetFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InfinispanCacheInfoBuilder {
    public static Set<InfinispanCacheInfo> build(Set<String> cacheNames, InfinispanCachesConfig runtimeConfig) {
        if (cacheNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.getInstance().apply(cacheNames.size());
        for (String cacheName : cacheNames) {
            InfinispanCacheInfo cacheInfo = new InfinispanCacheInfo();
            cacheInfo.name = cacheName;
            InfinispanCacheRuntimeConfig defaultRuntimeConfig = runtimeConfig.defaultConfig();
            InfinispanCacheRuntimeConfig namedRuntimeConfig = runtimeConfig.cachesConfig().get(cacheInfo.name);
            if (namedRuntimeConfig != null && namedRuntimeConfig.lifespan().isPresent()) {
                cacheInfo.lifespan = namedRuntimeConfig.lifespan();
            } else if (defaultRuntimeConfig.lifespan().isPresent()) {
                cacheInfo.lifespan = defaultRuntimeConfig.lifespan();
            }
            if (namedRuntimeConfig != null && namedRuntimeConfig.maxIdle().isPresent()) {
                cacheInfo.maxIdle = namedRuntimeConfig.maxIdle();
            } else if (defaultRuntimeConfig.maxIdle().isPresent()) {
                cacheInfo.maxIdle = defaultRuntimeConfig.maxIdle();
            }
            result.add(cacheInfo);
        }
        return result;
    }
}

