/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.infinispan.embedded.runtime.devui;

import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.manager.EmbeddedCacheManager;

@ApplicationScoped
public class InfinispanEmbeddedCacheJsonRPCService {
    @Inject
    EmbeddedCacheManager manager;

    @NonBlocking
    public JsonArray getAll() {
        Set names = this.manager.getCacheNames();
        ArrayList<AdvancedCache> allCaches = new ArrayList<AdvancedCache>(names.size());
        for (String name : names) {
            Cache cache = this.manager.getCache(name);
            if (cache == null) continue;
            allCaches.add(cache.getAdvancedCache());
        }
        allCaches.sort(Comparator.comparing(BasicCache::getName));
        JsonArray array = new JsonArray();
        for (AdvancedCache cc : allCaches) {
            array.add((Object)this.getJsonRepresentationForCache(cc));
        }
        return array;
    }

    private JsonObject getJsonRepresentationForCache(AdvancedCache cc) {
        if (cc != null) {
            return new JsonObject().put("name", (Object)cc.getName()).put("size", (Object)cc.size());
        }
        return new JsonObject().put("name", (Object)"unknown").put("size", (Object)-1);
    }

    public Uni<JsonObject> clear(String name) {
        Cache cache = this.manager.getCache(name);
        AdvancedCache advancedCache = this.getAdvancedCache(name);
        if (cache != null) {
            return Uni.createFrom().completionStage(cache.clearAsync().thenApply(t -> this.getJsonRepresentationForCache(advancedCache)));
        }
        return Uni.createFrom().item((Object)new JsonObject().put("name", (Object)name).put("size", (Object)-1));
    }

    @NonBlocking
    public JsonObject refresh(String name) {
        AdvancedCache advancedCache = this.getAdvancedCache(name);
        if (advancedCache != null) {
            return this.getJsonRepresentationForCache(advancedCache);
        }
        return new JsonObject().put("name", (Object)name).put("size", (Object)-1);
    }

    public JsonArray getKeys(String name) {
        AdvancedCache advancedCache = this.getAdvancedCache(name);
        if (advancedCache != null) {
            JsonArray keys = new JsonArray();
            for (Object key : advancedCache.keySet()) {
                keys.add((Object)key.toString());
            }
            return keys;
        }
        return JsonArray.of((Object[])new Object[0]);
    }

    private AdvancedCache getAdvancedCache(String name) {
        Cache cache = this.manager.getCache(name);
        if (cache != null) {
            return cache.getAdvancedCache();
        }
        return null;
    }
}

