/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.runtime.IronJacamarRuntimeConfig;
import io.quarkiverse.ironjacamar.runtime.QuarkusIronJacamarLogger;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;

@Dependent
public class ConnectionValidatorManager {
    @Inject
    ManagedExecutor managedExecutor;
    @Inject
    IronJacamarRuntimeConfig runtimeConfig;
    private static Boolean shouldStartConnectionValidator;

    @PostConstruct
    void postConstruct() {
        if (shouldStartConnectionValidator == null) {
            for (IronJacamarRuntimeConfig.ResourceAdapterOuterNamedConfig value : this.runtimeConfig.resourceAdapters().values()) {
                IronJacamarRuntimeConfig.ConnectionManagerConfig.PoolConfig.PoolConfigurationConfig config = value.ra().cm().pool().config();
                if (!config.backgroundValidation() || config.backgroundValidationMillis().orElse(0L) <= 0L) continue;
                shouldStartConnectionValidator = Boolean.TRUE;
                break;
            }
        }
        if (shouldStartConnectionValidator == null) {
            shouldStartConnectionValidator = Boolean.FALSE;
        }
    }

    void startConnectionValidator(@Observes StartupEvent event) throws Throwable {
        if (!shouldStartConnectionValidator.booleanValue()) {
            return;
        }
        QuarkusIronJacamarLogger.log.startConnectionValidatorService();
        ConnectionValidator instance = ConnectionValidator.getInstance();
        instance.setExecutorService((ExecutorService)this.managedExecutor);
        instance.start();
    }

    void stopConnectionValidator(@Observes ShutdownEvent event) throws Throwable {
        if (!shouldStartConnectionValidator.booleanValue()) {
            return;
        }
        QuarkusIronJacamarLogger.log.stopConnectionValidatorService();
        ConnectionValidator.getInstance().stop();
    }
}

