/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.runtime.IronJacamarRuntimeConfig;
import io.quarkiverse.ironjacamar.runtime.QuarkusIronJacamarLogger;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;

@Dependent
public class IdleRemoverManager {
    @Inject
    ManagedExecutor managedExecutor;
    @Inject
    IronJacamarRuntimeConfig runtimeConfig;
    private static Boolean shouldStartIdleRemover;

    @PostConstruct
    void postConstruct() {
        if (shouldStartIdleRemover == null) {
            for (IronJacamarRuntimeConfig.ResourceAdapterOuterNamedConfig value : this.runtimeConfig.resourceAdapters().values()) {
                if (value.ra().cm().pool().config().idleTimeoutMinutes() <= 0) continue;
                shouldStartIdleRemover = Boolean.TRUE;
                break;
            }
        }
        if (shouldStartIdleRemover == null) {
            shouldStartIdleRemover = Boolean.FALSE;
        }
    }

    void startIdleRemover(@Observes StartupEvent event) throws Throwable {
        if (!shouldStartIdleRemover.booleanValue()) {
            return;
        }
        QuarkusIronJacamarLogger.log.startIdleRemoverService();
        IdleRemover instance = IdleRemover.getInstance();
        instance.setExecutorService((ExecutorService)this.managedExecutor);
        instance.start();
    }

    void stopIdleRemover(@Observes ShutdownEvent event) throws Throwable {
        if (!shouldStartIdleRemover.booleanValue()) {
            return;
        }
        QuarkusIronJacamarLogger.log.stopIdleRemoverService();
        IdleRemover.getInstance().stop();
    }
}

