/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.ResourceAdapterFactory;
import io.quarkiverse.ironjacamar.runtime.TransactionRecoveryManager;
import io.quarkiverse.ironjacamar.runtime.endpoint.DefaultMessageEndpointFactory;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.io.Closeable;
import java.util.Map;
import org.jboss.jca.core.connectionmanager.ConnectionManager;

public class IronJacamarContainer
implements Closeable {
    private final ResourceAdapterFactory resourceAdapterFactory;
    private final ResourceAdapter resourceAdapter;
    private final ManagedConnectionFactory managedConnectionFactory;
    private final ConnectionManager connectionManager;
    private final TransactionRecoveryManager transactionRecoveryManager;

    public IronJacamarContainer(ResourceAdapterFactory resourceAdapterFactory, ResourceAdapter resourceAdapter, ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager, TransactionRecoveryManager transactionRecoveryManager) {
        this.resourceAdapterFactory = resourceAdapterFactory;
        this.resourceAdapter = resourceAdapter;
        this.managedConnectionFactory = managedConnectionFactory;
        this.connectionManager = connectionManager;
        this.transactionRecoveryManager = transactionRecoveryManager;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public ResourceAdapterFactory getResourceAdapterFactory() {
        return this.resourceAdapterFactory;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.managedConnectionFactory.createConnectionFactory((jakarta.resource.spi.ConnectionManager)this.connectionManager);
    }

    public void endpointActivation(Class<?> endpointClass, String identifier, Map<String, String> config) throws ResourceException {
        ActivationSpec activationSpec = this.resourceAdapterFactory.createActivationSpec(identifier, this.resourceAdapter, endpointClass, config);
        DefaultMessageEndpointFactory messageEndpointFactory = new DefaultMessageEndpointFactory(endpointClass, identifier, this.resourceAdapterFactory);
        this.resourceAdapter.endpointActivation((MessageEndpointFactory)messageEndpointFactory, activationSpec);
        if (this.transactionRecoveryManager.isEnabled()) {
            this.transactionRecoveryManager.registerForRecovery(this.resourceAdapter, activationSpec, this.resourceAdapterFactory.getProductName(), this.resourceAdapterFactory.getProductVersion());
        }
    }

    @Override
    public void close() {
        this.connectionManager.prepareShutdown();
        this.connectionManager.shutdown();
    }
}

