/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.runtime.IronJacamarContainer;
import io.quarkiverse.ironjacamar.runtime.IronJacamarRuntimeConfig;
import io.quarkiverse.ironjacamar.runtime.IronJacamarSupport;
import io.quarkiverse.ironjacamar.runtime.IronJacamarVerticle;
import io.quarkiverse.ironjacamar.runtime.TransactionRecoveryManager;
import io.quarkiverse.ironjacamar.runtime.listener.ResourceAdapterLifecycleListener;
import io.quarkiverse.ironjacamar.runtime.security.QuarkusSecurityIntegration;
import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.common.annotation.Identifier;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.XATerminator;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.naming.Reference;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.bootstrapcontext.BaseCloneableBootstrapContext;
import org.jboss.jca.core.bootstrapcontext.BootstrapContextCoordinator;
import org.jboss.jca.core.connectionmanager.ccm.CachedConnectionManagerImpl;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.security.SecurityIntegration;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.workmanager.WorkManagerCoordinator;
import org.jboss.jca.core.workmanager.WorkManagerImpl;

@Recorder
public class IronJacamarRecorder {
    public Function<SyntheticCreationalContext<IronJacamarContainer>, IronJacamarContainer> createContainerFunction(String id, String kind) {
        return context -> {
            IronJacamarSupport containerProducer = (IronJacamarSupport)context.getInjectedReference(IronJacamarSupport.class, new Annotation[0]);
            return containerProducer.createContainer(id, kind);
        };
    }

    public Function<SyntheticCreationalContext<Object>, Object> createConnectionFactory(String id) {
        return context -> {
            IronJacamarContainer container = (IronJacamarContainer)context.getInjectedReference(IronJacamarContainer.class, new Annotation[]{Identifier.Literal.of((String)id)});
            try {
                Object connectionFactory = container.createConnectionFactory();
                if (connectionFactory instanceof Referenceable) {
                    Referenceable ref = (Referenceable)connectionFactory;
                    ref.setReference(new Reference(connectionFactory.getClass().getCanonicalName(), null, null));
                }
                return connectionFactory;
            }
            catch (ResourceException e) {
                throw new DeploymentException("Cannot create connection factory", (Throwable)e);
            }
        };
    }

    public Function<SyntheticCreationalContext<CachedConnectionManager>, CachedConnectionManager> createCachedConnectionManager() {
        return context -> {
            TransactionIntegration ti = (TransactionIntegration)context.getInjectedReference(TransactionIntegration.class, new Annotation[0]);
            CachedConnectionManagerImpl cachedConnectionManager = new CachedConnectionManagerImpl(ti);
            cachedConnectionManager.start();
            return cachedConnectionManager;
        };
    }

    public Function<SyntheticCreationalContext<QuarkusSecurityIntegration>, QuarkusSecurityIntegration> createSecurityIntegration() {
        return context -> new QuarkusSecurityIntegration();
    }

    public Function<SyntheticCreationalContext<TransactionRecoveryManager>, TransactionRecoveryManager> createTransactionRecoveryManager() {
        return context -> {
            TransactionIntegration ti = (TransactionIntegration)context.getInjectedReference(TransactionIntegration.class, new Annotation[0]);
            RecoveryPlugin recoveryPlugin = (RecoveryPlugin)context.getInjectedReference(RecoveryPlugin.class, new Annotation[0]);
            boolean enableRecovery = ConfigProvider.getConfig().getOptionalValue("quarkus.transaction-manager.enable-recovery", Boolean.class).orElse(false);
            return new TransactionRecoveryManager(ti, recoveryPlugin, enableRecovery);
        };
    }

    public void initDefaultBootstrapContext(BeanContainer beanContainer) {
        TransactionIntegration transactionIntegration = (TransactionIntegration)beanContainer.beanInstance(TransactionIntegration.class, new Annotation[0]);
        SecurityIntegration securityIntegration = (SecurityIntegration)beanContainer.beanInstance(QuarkusSecurityIntegration.class, new Annotation[0]);
        BaseCloneableBootstrapContext bootstrapContext = new BaseCloneableBootstrapContext();
        ManagedExecutor executorService = (ManagedExecutor)beanContainer.beanInstance(ManagedExecutor.class, new Annotation[0]);
        WorkManagerImpl workManager = new WorkManagerImpl();
        workManager.setName("default");
        workManager.setSpecCompliant(true);
        workManager.setSecurityIntegration(securityIntegration);
        workManager.setShortRunningThreadPool((Executor)executorService);
        workManager.setLongRunningThreadPool((Executor)executorService);
        bootstrapContext.setName("default");
        bootstrapContext.setWorkManager((WorkManager)workManager);
        bootstrapContext.setWorkManagerName("default");
        bootstrapContext.setTransactionSynchronizationRegistry(transactionIntegration.getTransactionSynchronizationRegistry());
        bootstrapContext.setXATerminator((XATerminator)transactionIntegration.getXATerminator());
        WorkManagerCoordinator.getInstance().setDefaultWorkManager((WorkManager)workManager);
        BootstrapContextCoordinator.getInstance().setDefaultBootstrapContext((CloneableBootstrapContext)bootstrapContext);
    }

    public RuntimeValue<Future<String>> initResourceAdapter(BeanContainer beanContainer, String key, Supplier<Vertx> vertxSupplier, IronJacamarRuntimeConfig config) {
        Vertx vertx = vertxSupplier.get();
        IronJacamarContainer ijContainer = (IronJacamarContainer)beanContainer.beanInstance(IronJacamarContainer.class, new Annotation[]{Identifier.Literal.of((String)key)});
        CloneableBootstrapContext bootstrapContext = BootstrapContextCoordinator.getInstance().getDefaultBootstrapContext();
        List<ResourceAdapterLifecycleListener> listeners = Arc.container().select(ResourceAdapterLifecycleListener.class, new Annotation[0]).stream().toList();
        IronJacamarVerticle verticle = new IronJacamarVerticle(key, ijContainer, bootstrapContext, listeners);
        Duration maxWorkerExecuteTime = config.maxWorkerExecuteTime();
        Future future = vertx.deployVerticle((Verticle)verticle, new DeploymentOptions().setWorkerPoolName("jca-worker-pool-" + key).setWorkerPoolSize(1).setThreadingModel(ThreadingModel.WORKER).setMaxWorkerExecuteTime(maxWorkerExecuteTime.toMillis()).setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS));
        return new RuntimeValue((Object)future);
    }

    public void activateEndpoint(BeanContainer beanContainer, RuntimeValue<Future<String>> containerFuture, String resourceAdapterId, String activationSpecConfigId, String endpointClassName, Map<String, String> buildTimeConfig) {
        Future future = (Future)containerFuture.getValue();
        future.onSuccess(s -> {
            IronJacamarSupport producer = (IronJacamarSupport)beanContainer.beanInstance(IronJacamarSupport.class, new Annotation[0]);
            producer.activateEndpoint(resourceAdapterId, activationSpecConfigId, endpointClassName, buildTimeConfig);
        });
    }
}

