/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import jakarta.resource.spi.TransactionSupport;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;

@ConfigMapping(prefix="quarkus.ironjacamar")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface IronJacamarRuntimeConfig {
    @WithDefault(value="${quarkus.vertx.max-worker-execute-time:60}")
    public Duration maxWorkerExecuteTime();

    @ConfigDocMapKey(value="resource-adapter-name")
    @WithParentName
    @WithDefaults
    @WithUnnamedKey(value="<default>")
    public @WithUnnamedKey(value="<default>") Map<String, ResourceAdapterOuterNamedConfig> resourceAdapters();

    @WithName(value="activation-spec")
    public ActivationSpecOuterNamedConfig activationSpecs();

    public static interface ActivationSpecConfig {
        public Map<String, String> config();
    }

    @ConfigGroup
    public static interface ActivationSpecOuterNamedConfig {
        @ConfigDocMapKey(value="activation-spec-name")
        @WithParentName
        @WithDefaults
        @WithUnnamedKey(value="<default>")
        public @WithUnnamedKey(value="<default>") Map<String, ActivationSpecConfig> map();
    }

    @ConfigGroup
    public static interface ConnectionManagerConfig {
        @WithDefault(value="XATransaction")
        public TransactionSupport.TransactionSupportLevel transactionSupportLevel();

        @WithDefault(value="5")
        public int allocationRetry();

        @WithDefault(value="1s")
        public Duration allocationRetryWait();

        @WithDefault(value="120s")
        public Duration xaResourceTimeout();

        @WithDefault(value="failing-connection-only")
        public FlushStrategy flushStrategy();

        @WithDefault(value="true")
        public boolean sharable();

        @WithDefault(value="true")
        public boolean enlistment();

        @WithDefault(value="false")
        public boolean connectable();

        public Optional<Boolean> tracking();

        @WithDefault(value="true")
        public boolean useCcm();

        @WithDefault(value="false")
        public boolean interleaving();

        @WithName(value="is-same-rm-override")
        public Optional<Boolean> isSameRMOverride();

        @WithDefault(value="true")
        @WithName(value="wrap-xa-resource")
        public boolean wrapXAResource();

        @WithDefault(value="false")
        public boolean padXid();

        public RecoveryConfig recovery();

        public PoolConfig pool();

        @ConfigGroup
        public static interface PoolConfig {
            @WithDefault(value="pool-by-cri")
            public PoolStrategy strategy();

            public PoolConfigurationConfig config();

            @WithDefault(value="true")
            public boolean sharable();

            @WithDefault(value="false")
            public boolean noTxSeparatePool();

            public static interface PoolConfigurationConfig {
                @WithDefault(value="0")
                public int minSize();

                public OptionalInt initialSize();

                @WithDefault(value="20")
                public int maxSize();

                @WithDefault(value="30000ms")
                public Duration blockingTimeout();

                @WithDefault(value="30")
                public int idleTimeoutMinutes();

                @WithDefault(value="false")
                public boolean validateOnMatch();

                @WithDefault(value="false")
                public boolean backgroundValidation();

                public OptionalLong backgroundValidationMillis();

                @WithDefault(value="false")
                public boolean prefill();

                @WithDefault(value="false")
                public boolean strictMin();

                @WithDefault(value="false")
                public boolean useFastFail();

                @WithDefault(value="true")
                public boolean fair();

                default public PoolConfiguration toPoolConfiguration() {
                    PoolConfiguration poolConfiguration = new PoolConfiguration();
                    poolConfiguration.setMinSize(this.minSize());
                    this.initialSize().ifPresent(arg_0 -> ((PoolConfiguration)poolConfiguration).setInitialSize(arg_0));
                    poolConfiguration.setMaxSize(this.maxSize());
                    poolConfiguration.setBlockingTimeout(this.blockingTimeout().toMillis());
                    poolConfiguration.setIdleTimeoutMinutes(this.idleTimeoutMinutes());
                    poolConfiguration.setValidateOnMatch(this.validateOnMatch());
                    poolConfiguration.setBackgroundValidation(this.backgroundValidation());
                    this.backgroundValidationMillis().ifPresent(arg_0 -> ((PoolConfiguration)poolConfiguration).setBackgroundValidationMillis(arg_0));
                    poolConfiguration.setPrefill(this.prefill());
                    poolConfiguration.setStrictMin(this.strictMin());
                    poolConfiguration.setUseFastFail(this.useFastFail());
                    poolConfiguration.setFair(this.fair());
                    return poolConfiguration;
                }
            }
        }

        @ConfigGroup
        public static interface RecoveryConfig {
            public Optional<String> username();

            public Optional<String> password();

            public Optional<String> securityDomain();
        }
    }

    public static interface ResourceAdapterConfig {
        public Map<String, String> config();

        public ConnectionManagerConfig cm();
    }

    @ConfigGroup
    public static interface ResourceAdapterOuterNamedConfig {
        public ResourceAdapterConfig ra();
    }
}

