/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.ResourceAdapterFactory;
import io.quarkiverse.ironjacamar.ResourceAdapterKind;
import io.quarkiverse.ironjacamar.runtime.ConnectionManagerFactory;
import io.quarkiverse.ironjacamar.runtime.IronJacamarContainer;
import io.quarkiverse.ironjacamar.runtime.IronJacamarRuntimeConfig;
import io.quarkiverse.ironjacamar.runtime.QuarkusIronJacamarLogger;
import io.quarkiverse.ironjacamar.runtime.TransactionRecoveryManager;
import io.quarkus.arc.Unremovable;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;

@Dependent
@Unremovable
public class IronJacamarSupport {
    private final IronJacamarRuntimeConfig runtimeConfig;
    private final ConnectionManagerFactory connectionManagerFactory;
    private final TransactionRecoveryManager transactionRecoveryManager;
    private final Instance<IronJacamarContainer> containers;
    private final Instance<ResourceAdapterFactory> resourceAdapterFactories;

    @Inject
    public IronJacamarSupport(IronJacamarRuntimeConfig runtimeConfig, ConnectionManagerFactory connectionManagerFactory, TransactionRecoveryManager transactionRecoveryManager, @Any Instance<IronJacamarContainer> containers, @Any Instance<ResourceAdapterFactory> resourceAdapterFactories) {
        this.runtimeConfig = runtimeConfig;
        this.connectionManagerFactory = connectionManagerFactory;
        this.transactionRecoveryManager = transactionRecoveryManager;
        this.containers = containers;
        this.resourceAdapterFactories = resourceAdapterFactories;
    }

    public IronJacamarContainer createContainer(String id, String kind) {
        ConnectionManager connectionManager;
        ManagedConnectionFactory managedConnectionFactory;
        ResourceAdapter resourceAdapter;
        ResourceAdapterFactory resourceAdapterFactory = (ResourceAdapterFactory)this.resourceAdapterFactories.select(new Annotation[]{ResourceAdapterKind.Literal.of(kind)}).get();
        IronJacamarRuntimeConfig.ResourceAdapterOuterNamedConfig adapterRuntimeConfig = this.runtimeConfig.resourceAdapters().get(id);
        IronJacamarRuntimeConfig.ResourceAdapterConfig ra = adapterRuntimeConfig.ra();
        try {
            resourceAdapter = resourceAdapterFactory.createResourceAdapter(id, ra.config());
            managedConnectionFactory = resourceAdapterFactory.createManagedConnectionFactory(id, resourceAdapter);
            connectionManager = this.connectionManagerFactory.createConnectionManager(id, managedConnectionFactory, ra.cm());
            if (this.transactionRecoveryManager.isEnabled()) {
                if (connectionManager instanceof TxConnectionManager) {
                    this.transactionRecoveryManager.registerForRecovery(managedConnectionFactory, (TxConnectionManager)connectionManager, ra.cm().recovery().username().orElse(null), ra.cm().recovery().password().orElse(null), ra.cm().recovery().securityDomain().orElse(null));
                } else {
                    QuarkusIronJacamarLogger.log.connectionManagerNotTransactional(id);
                }
            }
        }
        catch (ResourceException re) {
            throw QuarkusIronJacamarLogger.log.cannotDeployResourceAdapter((Exception)((Object)re));
        }
        return new IronJacamarContainer(resourceAdapterFactory, resourceAdapter, managedConnectionFactory, connectionManager, this.transactionRecoveryManager);
    }

    public void activateEndpoint(String containerId, String activationSpecConfigId, String endpointClassName, Map<String, String> buildTimeConfig) {
        IronJacamarRuntimeConfig.ActivationSpecConfig activationSpecConfig;
        Class<?> endpointClass;
        IronJacamarContainer ijContainer = (IronJacamarContainer)this.containers.select(new Annotation[]{Identifier.Literal.of((String)containerId)}).get();
        try {
            endpointClass = Class.forName(endpointClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> config = new HashMap<String, String>(buildTimeConfig);
        if (activationSpecConfigId != null && (activationSpecConfig = this.runtimeConfig.activationSpecs().map().get(activationSpecConfigId)) != null) {
            config.putAll(activationSpecConfig.config());
        }
        try {
            ijContainer.endpointActivation(endpointClass, containerId, config);
        }
        catch (ResourceException e) {
            throw QuarkusIronJacamarLogger.log.cannotActivateEndpoint((Exception)((Object)e));
        }
    }
}

