/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.runtime.IronJacamarContainer;
import io.quarkiverse.ironjacamar.runtime.QuarkusIronJacamarLogger;
import io.quarkiverse.ironjacamar.runtime.listener.ResourceAdapterLifecycleListener;
import io.vertx.core.AbstractVerticle;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import java.util.Collection;
import java.util.Objects;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.WorkManager;

final class IronJacamarVerticle
extends AbstractVerticle {
    private final String id;
    private final CloneableBootstrapContext bootstrapContext;
    private final IronJacamarContainer ironJacamarContainer;
    private final Collection<ResourceAdapterLifecycleListener> listeners;

    public IronJacamarVerticle(String id, IronJacamarContainer container, CloneableBootstrapContext bootstrapContext, Collection<ResourceAdapterLifecycleListener> listeners) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.ironJacamarContainer = Objects.requireNonNull(container, "container cannot be null");
        this.bootstrapContext = Objects.requireNonNull(bootstrapContext, "bootstrapContext cannot be null");
        this.listeners = Objects.requireNonNull(listeners, "listeners cannot be null");
    }

    public void start() throws Exception {
        QuarkusIronJacamarLogger.log.startingResourceAdapter(this.id, this.ironJacamarContainer.getResourceAdapterFactory().getDescription());
        ResourceAdapter resourceAdapter = this.ironJacamarContainer.getResourceAdapter();
        for (ResourceAdapterLifecycleListener listener : this.listeners) {
            listener.preStartup(this.id, resourceAdapter);
        }
        resourceAdapter.start((BootstrapContext)this.bootstrapContext);
        for (ResourceAdapterLifecycleListener listener : this.listeners) {
            listener.postStartup(this.id, resourceAdapter);
        }
    }

    public void stop() {
        QuarkusIronJacamarLogger.log.stoppingResourceAdapter(this.id);
        ResourceAdapter resourceAdapter = this.ironJacamarContainer.getResourceAdapter();
        for (ResourceAdapterLifecycleListener listener : this.listeners) {
            listener.preShutdown(this.id, resourceAdapter);
        }
        resourceAdapter.stop();
        for (ResourceAdapterLifecycleListener listener : this.listeners) {
            listener.postShutdown(this.id, resourceAdapter);
        }
        ((WorkManager)this.bootstrapContext.getWorkManager()).shutdown();
        this.bootstrapContext.shutdown();
    }
}

