/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.resource.ResourceException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="QIJ")
public interface QuarkusIronJacamarLogger
extends BasicLogger {
    public static final QuarkusIronJacamarLogger log = (QuarkusIronJacamarLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), QuarkusIronJacamarLogger.class, (String)QuarkusIronJacamarLogger.class.getPackageName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Starting Resource Adapter %s: %s")
    public void startingResourceAdapter(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Stopping Resource Adapter %s")
    public void stoppingResourceAdapter(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="No default resource adapter kind found. IronJacamar is disabled")
    public void noDefaultResourceAdapterKindFound();

    @Message(id=4, value="Resource adapter factory %s must be annotated with @ResourceAdapterKind")
    public DeploymentException resourceAdapterFactoryMustBeAnnotatedException(String var1);

    @Message(id=5, value="Because there are more than one resource adapter configured, you need to explicitly use the @Identifier annotation on %s")
    public DeploymentException useIdentifierAnnotation(String var1);

    @Message(id=6, value="Multiple kinds found (%s), please set the kind config for the %s configuration")
    public ConfigurationException multipleKindsFound(Set<String> var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="The connection manager for the resource adapter %s is not transactional, therefore it cannot be registered for recovery")
    public void connectionManagerNotTransactional(String var1);

    @Message(id=8, value="Error during recovery initialization")
    public ResourceException errorDuringRecoveryInitialization(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Error during recovery shutdown")
    public void errorDuringRecoveryShutdown(@Cause Exception var1);

    @Message(id=10, value="Cannot deploy resource adapter")
    public DeploymentException cannotDeployResourceAdapter(@Cause Exception var1);

    @Message(id=11, value="Cannot activate endpoint")
    public DeploymentException cannotActivateEndpoint(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="The @ResourceAdapterTypes annotation was not found in %s. Injection of ConnectionFactories for this ResourceAdapter will not work")
    public void resourceAdapterTypesNotDefined(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Starting JCA Pool Connection Validator service")
    public void startConnectionValidatorService();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Stopping JCA Pool Connection Validator service")
    public void stopConnectionValidatorService();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="Starting JCA Pool Idle Remover service")
    public void startIdleRemoverService();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Stopping JCA Pool Idle Remover service")
    public void stopIdleRemoverService();
}

