/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime;

import io.quarkiverse.ironjacamar.runtime.QuarkusIronJacamarLogger;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.XAResourceStatistics;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;

public class TransactionRecoveryManager
implements Closeable {
    private final TransactionIntegration transactionIntegration;
    private final RecoveryPlugin recoveryPlugin;
    private final Set<XAResourceRecovery> recoverySet = new HashSet<XAResourceRecovery>();
    private final boolean enabled;

    public TransactionRecoveryManager(TransactionIntegration transactionIntegration, RecoveryPlugin recoveryPlugin, boolean enabled) {
        this.transactionIntegration = transactionIntegration;
        this.recoveryPlugin = recoveryPlugin;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void registerForRecovery(ManagedConnectionFactory mcf, TxConnectionManager cm, String recoveryUsername, String recoveryPassword, String recoverySecurityDomain) throws ResourceException {
        XAResourceRecovery xaResourceRecovery = this.transactionIntegration.createXAResourceRecovery(mcf, Boolean.valueOf(cm.getPadXid()), cm.getIsSameRMOverride(), Boolean.valueOf(cm.getWrapXAResource()), recoveryUsername, recoveryPassword, recoverySecurityDomain, cm.getSubjectFactory(), this.recoveryPlugin, (XAResourceStatistics)cm.getPool().getStatistics());
        this.initialize(xaResourceRecovery);
    }

    public void registerForRecovery(ResourceAdapter resourceAdapter, ActivationSpec activationSpec, String productName, String productVersion) throws ResourceException {
        XAResourceRecovery xrr = this.transactionIntegration.createXAResourceRecovery(resourceAdapter, activationSpec, productName, productVersion);
        this.initialize(xrr);
    }

    private void initialize(XAResourceRecovery recovery) throws ResourceException {
        try {
            recovery.initialize();
            this.transactionIntegration.getRecoveryRegistry().addXAResourceRecovery(recovery);
            this.recoverySet.add(recovery);
        }
        catch (Exception e) {
            throw QuarkusIronJacamarLogger.log.errorDuringRecoveryInitialization(e);
        }
    }

    @Override
    public void close() {
        for (XAResourceRecovery xrr : this.recoverySet) {
            try {
                this.transactionIntegration.getRecoveryRegistry().removeXAResourceRecovery(xrr);
                xrr.shutdown();
            }
            catch (Exception e) {
                QuarkusIronJacamarLogger.log.errorDuringRecoveryShutdown(e);
            }
        }
        this.recoverySet.clear();
    }
}

