/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime.endpoint;

import io.quarkiverse.ironjacamar.runtime.endpoint.MessageEndpointWrapper;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.lang.reflect.Method;

class ClassLoaderMessageEndpoint
extends MessageEndpointWrapper {
    private final ClassLoader classLoader;
    private ClassLoader originalClassLoader;

    public ClassLoaderMessageEndpoint(MessageEndpoint delegate, ClassLoader classLoader) {
        super(delegate);
        this.classLoader = classLoader;
    }

    @Override
    public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        super.beforeDelivery(method);
    }

    @Override
    public void afterDelivery() throws ResourceException {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        super.afterDelivery();
    }

    @Override
    public void release() {
        this.originalClassLoader = null;
        super.release();
    }
}

