/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime.endpoint;

import io.quarkiverse.ironjacamar.ResourceAdapterFactory;
import io.quarkiverse.ironjacamar.runtime.endpoint.ClassLoaderMessageEndpoint;
import io.quarkiverse.ironjacamar.runtime.endpoint.NoopMessageEndpoint;
import io.quarkiverse.ironjacamar.runtime.endpoint.TransactionAwareMessageEndpoint;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.common.annotation.Identifier;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.transaction.Transactional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.transaction.xa.XAResource;

public class DefaultMessageEndpointFactory
implements MessageEndpointFactory {
    private final Class<?> endpointClass;
    private final String identifier;
    private final ResourceAdapterFactory resourceAdapterSupport;
    private final ClassLoader classLoader;
    private Boolean transacted;

    public DefaultMessageEndpointFactory(Class<?> endpointClass, String identifier, ResourceAdapterFactory adapterFactory) {
        this.endpointClass = endpointClass;
        this.identifier = identifier;
        this.resourceAdapterSupport = adapterFactory;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        if (this.transacted == null) {
            Method endpointClassMethod = this.endpointClass.getMethod(method.getName(), method.getParameterTypes());
            Transactional annotation = endpointClassMethod.getAnnotation(Transactional.class);
            this.transacted = annotation == null ? Boolean.FALSE : Boolean.valueOf(annotation.value() != Transactional.TxType.NEVER && annotation.value() != Transactional.TxType.NOT_SUPPORTED);
        }
        return this.transacted;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        return this.createEndpoint(xaResource);
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) {
        MessageEndpoint endpoint = xaResource == null ? NoopMessageEndpoint.INSTANCE : new TransactionAwareMessageEndpoint(xaResource);
        if (LaunchMode.current() != LaunchMode.NORMAL) {
            endpoint = new ClassLoaderMessageEndpoint(endpoint, this.classLoader);
        }
        return this.resourceAdapterSupport.wrap(endpoint, this.getEndpointInstance());
    }

    public String getActivationName() {
        return this.endpointClass.getName();
    }

    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    private Object getEndpointInstance() {
        Object instance;
        ArcContainer container = Arc.container();
        if ("<default>".equals(this.identifier)) {
            instance = container.select(this.endpointClass, new Annotation[]{Identifier.Literal.of((String)this.identifier)}).orElse(null);
            if (instance == null) {
                instance = container.select(this.endpointClass, new Annotation[0]).get();
            }
        } else {
            instance = container.select(this.endpointClass, new Annotation[]{Identifier.Literal.of((String)this.identifier)}).get();
        }
        return Objects.requireNonNull(instance, "Unable to find endpoint instance for " + this.endpointClass.getName() + " with identifier " + this.identifier + " in Arc container");
    }
}

