/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.ironjacamar.runtime.endpoint;

import com.arjuna.ats.jta.UserTransaction;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.narayana.jta.QuarkusTransaction;
import io.quarkus.narayana.jta.QuarkusTransactionException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;

public class TransactionAwareMessageEndpoint
implements MessageEndpoint {
    private final XAResource xaResource;

    public TransactionAwareMessageEndpoint(XAResource xaResource) {
        this.xaResource = xaResource;
    }

    public void beforeDelivery(Method method) throws ResourceException {
        Arc.container().requestContext().activate();
        QuarkusTransaction.begin();
        try {
            Transaction transaction = ((TransactionManager)Arc.container().select(TransactionManager.class, new Annotation[0]).get()).getTransaction();
            if (!transaction.enlistResource(this.xaResource)) {
                throw new ResourceException("Cannot enlist resource");
            }
        }
        catch (RollbackException | SystemException e) {
            throw new ResourceException("Error while enlisting resource", e);
        }
    }

    public void afterDelivery() {
        try {
            int currentStatus = this.getStatus();
            if (this.isActive(currentStatus)) {
                if (currentStatus == 1) {
                    QuarkusTransaction.rollback();
                } else {
                    QuarkusTransaction.commit();
                }
            }
        }
        finally {
            ManagedContext context = Arc.container().requestContext();
            if (context.isActive()) {
                context.deactivate();
            }
        }
    }

    public void release() {
    }

    int getStatus() {
        try {
            return UserTransaction.userTransaction().getStatus();
        }
        catch (SystemException e) {
            throw new QuarkusTransactionException((Throwable)e);
        }
    }

    boolean isActive(int status) {
        return status == 0 || status == 1 || status == 2 || status == 5 || status == 7 || status == 8 || status == 9;
    }
}

