/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.Markup;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.pdf.HyphenationAuto;
import com.lowagie.text.pdf.HyphenationEvent;
import java.awt.Color;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontFactoryImp fontImp = FontFactory.getFontImp();
    public static HashMap followTags = new HashMap();

    public Chunk createChunk(String text, ChainedProperties props) {
        Font font = this.getFont(props);
        float size = font.getSize();
        size /= 2.0f;
        Chunk ck = new Chunk(text, font);
        if (props.hasProperty("sub")) {
            ck.setTextRise(-size);
        } else if (props.hasProperty("sup")) {
            ck.setTextRise(size);
        }
        ck.setHyphenation(FactoryProperties.getHyphenation(props));
        return ck;
    }

    private static void setParagraphLeading(Paragraph p, String leading) {
        if (leading == null) {
            p.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.parseFloat(v);
            if (!tk.hasMoreTokens()) {
                p.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.parseFloat(v);
            p.setLeading(v1, v2);
        }
        catch (Exception e) {
            p.setLeading(0.0f, 1.5f);
        }
    }

    public static void createParagraph(Paragraph p, ChainedProperties props) {
        String value = props.getProperty("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        p.setHyphenation(FactoryProperties.getHyphenation(props));
        FactoryProperties.setParagraphLeading(p, props.getProperty("leading"));
        value = props.getProperty("before");
        if (value != null) {
            try {
                p.setSpacingBefore(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("after")) != null) {
            try {
                p.setSpacingAfter(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("extraparaspace")) != null) {
            try {
                p.setExtraParagraphSpace(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties props) {
        Paragraph p = new Paragraph();
        FactoryProperties.createParagraph(p, props);
        return p;
    }

    public static ListItem createListItem(ChainedProperties props) {
        ListItem p = new ListItem();
        FactoryProperties.createParagraph(p, props);
        return p;
    }

    public Font getFont(ChainedProperties props) {
        String face = props.getProperty("face");
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (!this.fontImp.isRegistered(face)) continue;
            }
        }
        int style = 0;
        if (props.hasProperty("i")) {
            style |= 2;
        }
        if (props.hasProperty("b")) {
            style |= 1;
        }
        if (props.hasProperty("u")) {
            style |= 4;
        }
        if (props.hasProperty("s")) {
            style |= 8;
        }
        String value = props.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.parseFloat(value);
        }
        Color color = Markup.decodeColor(props.getProperty("color"));
        String encoding = props.getProperty("encoding");
        if (encoding == null) {
            encoding = "Cp1252";
        }
        return this.fontImp.getFont(face, encoding, true, size, style, color);
    }

    public static HyphenationEvent getHyphenation(ChainedProperties props) {
        return FactoryProperties.getHyphenation(props.getProperty("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(HashMap props) {
        return FactoryProperties.getHyphenation((String)props.get("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String lang = s;
        String country = null;
        int leftMin = 2;
        int rightMin = 2;
        int pos = s.indexOf(95);
        if (pos == -1) {
            return new HyphenationAuto(lang, country, leftMin, rightMin);
        }
        lang = s.substring(0, pos);
        country = s.substring(pos + 1);
        if ((pos = country.indexOf(44)) == -1) {
            return new HyphenationAuto(lang, country, leftMin, rightMin);
        }
        s = country.substring(pos + 1);
        country = country.substring(0, pos);
        pos = s.indexOf(44);
        if (pos == -1) {
            leftMin = Integer.parseInt(s);
        } else {
            leftMin = Integer.parseInt(s.substring(0, pos));
            rightMin = Integer.parseInt(s.substring(pos + 1));
        }
        return new HyphenationAuto(lang, country, leftMin, rightMin);
    }

    public static void insertStyle(HashMap h) {
        String style = (String)h.get("style");
        if (style == null) {
            return;
        }
        Properties prop = Markup.parseAttributes(style);
        for (String string : prop.keySet()) {
            String ss;
            if (string.equals("font-family")) {
                h.put("face", prop.getProperty(string));
                continue;
            }
            if (string.equals("font-size")) {
                h.put("size", Float.toString(Markup.parseLength(prop.getProperty(string))) + "pt");
                continue;
            }
            if (string.equals("font-style")) {
                ss = prop.getProperty(string).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h.put("i", null);
                continue;
            }
            if (string.equals("font-weight")) {
                ss = prop.getProperty(string).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h.put("b", null);
                continue;
            }
            if (string.equals("text-decoration")) {
                ss = prop.getProperty(string).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h.put("u", null);
                continue;
            }
            if (string.equals("color")) {
                Color c = Markup.decodeColor(prop.getProperty(string));
                if (c == null) continue;
                int hh = c.getRGB();
                Object hs = Integer.toHexString(hh);
                hs = "000000" + (String)hs;
                hs = "#" + ((String)hs).substring(((String)hs).length() - 6);
                h.put("color", hs);
                continue;
            }
            if (string.equals("line-height")) {
                ss = prop.getProperty(string).trim();
                float v = Markup.parseLength(prop.getProperty(string));
                if (ss.endsWith("%")) {
                    h.put("leading", "0," + v / 100.0f);
                    continue;
                }
                if ("normal".equalsIgnoreCase(ss)) {
                    h.put("leading", "0,1.5");
                    continue;
                }
                h.put("leading", v + ",0");
                continue;
            }
            if (!string.equals("text-align")) continue;
            ss = prop.getProperty(string).trim().toLowerCase();
            h.put("align", ss);
        }
    }

    public static void insertStyle(HashMap h, ChainedProperties cprops) {
        String style = (String)h.get("style");
        if (style == null) {
            return;
        }
        Properties prop = Markup.parseAttributes(style);
        for (String string : prop.keySet()) {
            if (string.equals("font-family")) {
                h.put("face", prop.getProperty(string));
                continue;
            }
            if (string.equals("font-size")) {
                float actualFontSize = Markup.parseLength(cprops.getProperty("size"), 12.0f);
                if (actualFontSize <= 0.0f) {
                    actualFontSize = 12.0f;
                }
                h.put("size", Float.toString(Markup.parseLength(prop.getProperty(string), actualFontSize)) + "pt");
                continue;
            }
            if (string.equals("font-style")) {
                String ss = prop.getProperty(string).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h.put("i", null);
                continue;
            }
            if (string.equals("font-weight")) {
                String ss = prop.getProperty(string).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h.put("b", null);
                continue;
            }
            if (string.equals("text-decoration")) {
                String ss = prop.getProperty(string).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h.put("u", null);
                continue;
            }
            if (string.equals("color")) {
                Color c = Markup.decodeColor(prop.getProperty(string));
                if (c == null) continue;
                int hh = c.getRGB();
                Object hs = Integer.toHexString(hh);
                hs = "000000" + (String)hs;
                hs = "#" + ((String)hs).substring(((String)hs).length() - 6);
                h.put("color", hs);
                continue;
            }
            if (string.equals("line-height")) {
                String ss = prop.getProperty(string).trim();
                float actualFontSize = Markup.parseLength(cprops.getProperty("size"), 12.0f);
                if (actualFontSize <= 0.0f) {
                    actualFontSize = 12.0f;
                }
                float v = Markup.parseLength(prop.getProperty(string), actualFontSize);
                if (ss.endsWith("%")) {
                    h.put("leading", "0," + v / 100.0f);
                    return;
                }
                if ("normal".equalsIgnoreCase(ss)) {
                    h.put("leading", "0,1.5");
                    return;
                }
                if (v != 0.0f && Character.isDigit(ss.charAt(ss.length() - 1))) {
                    h.put("leading", "0," + v);
                    continue;
                }
                h.put("leading", v + ",0");
                continue;
            }
            if (string.equals("text-align")) {
                String ss = prop.getProperty(string).trim().toLowerCase();
                h.put("align", ss);
                continue;
            }
            if (!string.equals("padding-left")) continue;
            String ss = prop.getProperty(string).trim().toLowerCase();
            h.put("indent", Float.toString(Markup.parseLength(ss)));
        }
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontImp) {
        this.fontImp = fontImp;
    }

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        followTags.put("s", "s");
        followTags.put("strike", "s");
    }
}

