/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jackson.jq.deployment;

import io.quarkiverse.jackson.jq.JacksonJqScopeRecorder;
import io.quarkiverse.jackson.jq.JqFunction;
import io.quarkiverse.jackson.jq.deployment.JacksonJqConfig;
import io.quarkiverse.jackson.jq.deployment.JacksonJqFunctionBuildItem;
import io.quarkiverse.jackson.jq.deployment.JacksonJqSupport;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.RuntimeValue;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import org.apache.commons.lang3.StringUtils;
import org.jboss.jandex.IndexView;

class JacksonJqProcessor {
    private static final String FEATURE = "jackson-jq";

    JacksonJqProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem quarkusScopeBean(CombinedIndexBuildItem combinedIndex, ApplicationArchivesBuildItem archives, JacksonJqConfig config, JacksonJqScopeRecorder recorder, List<JacksonJqFunctionBuildItem> functions, RecorderContext context) throws Exception {
        IndexView indexView = combinedIndex.getIndex();
        List excludes = config.functions.excludes.orElseGet(Collections::emptyList);
        RuntimeValue root = recorder.createScope();
        RuntimeValue local = recorder.createScope(root);
        JacksonJqSupport.lookupFunctionsFromConfig(archives, config).forEach(e -> {
            if (!excludes.contains(e.name)) {
                recorder.addFunction(root, e.name, e.args, e.body, config.functions.version.toString());
            }
        });
        JacksonJqSupport.lookupFunctions(indexView, config, context, net.thisptr.jackson.jq.BuiltinFunction.class).forEach(f -> {
            if (!excludes.contains(StringUtils.substringBefore((String)f.getName(), (int)47))) {
                recorder.addFunction(root, f.getName(), f.getFunction());
            }
        });
        JacksonJqSupport.lookupFunctions(indexView, config, context, BuiltinFunction.class).forEach(f -> {
            if (!excludes.contains(StringUtils.substringBefore((String)f.getName(), (int)47))) {
                recorder.addFunction(root, f.getName(), f.getFunction());
            }
        });
        JacksonJqSupport.lookupFunctions(indexView, config, context, JqFunction.class).forEach(f -> {
            if (!excludes.contains(StringUtils.substringBefore((String)f.getName(), (int)47))) {
                recorder.addFunction(local, f.getName(), f.getFunction());
            }
        });
        functions.forEach(f -> {
            if (!excludes.contains(StringUtils.substringBefore((String)f.getName(), (int)47))) {
                recorder.addFunction(local, f.getName(), f.getFunction());
            }
        });
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Scope.class).scope(Singleton.class)).runtimeValue(local).done();
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans() {
        return UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{Scope.class});
    }
}

