/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.deployment;

import io.jaegertracing.internal.JaegerTracer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.jaeger.deployment.JaegerEnabled;
import io.quarkus.jaeger.runtime.JaegerBuildTimeConfig;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.JaegerDeploymentRecorder;
import io.quarkus.jaeger.runtime.ZipkinConfig;
import io.quarkus.runtime.ApplicationConfig;
import java.util.Optional;

@BuildSteps(onlyIf={JaegerEnabled.class})
public class JaegerProcessor {
    static final String FEATURE = "jaeger";

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void setVersion(JaegerDeploymentRecorder jdr) {
        jdr.setJaegerVersion(JaegerTracer.getVersionFromProperties());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ExtensionSslNativeSupportBuildItem setupTracer(JaegerDeploymentRecorder jdr, JaegerBuildTimeConfig buildTimeConfig, JaegerConfig jaeger, ApplicationConfig appConfig, Optional<MetricsCapabilityBuildItem> metricsCapability, ZipkinConfig zipkinConfig) {
        if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
            if (metricsCapability.get().metricsSupported("micrometer")) {
                jdr.registerTracerWithMicrometerMetrics(jaeger, appConfig, zipkinConfig);
            } else {
                jdr.registerTracerWithMpMetrics(jaeger, appConfig, zipkinConfig);
            }
        } else {
            jdr.registerTracerWithoutMetrics(jaeger, appConfig, zipkinConfig);
        }
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectiveClasses() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"io.jaegertracing.internal.samplers.http.OperationSamplingParameters", "io.jaegertracing.internal.samplers.http.PerOperationSamplingParameters", "io.jaegertracing.internal.samplers.http.ProbabilisticSamplingStrategy", "io.jaegertracing.internal.samplers.http.RateLimitingSamplingStrategy", "io.jaegertracing.internal.samplers.http.SamplingStrategyResponse"}).fields().build();
    }
}

