/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jasperreports.deployment;

import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.logging.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

abstract class AbstractJandexProcessor {
    AbstractJandexProcessor() {
    }

    protected List<String> collectClassesInPackage(CombinedIndexBuildItem combinedIndex, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<DotName> packages = new ArrayList<DotName>(combinedIndex.getIndex().getSubpackages(packageName));
        packages.add(DotName.createSimple((String)packageName));
        for (DotName aPackage : packages) {
            List<String> packageClasses = combinedIndex.getIndex().getClassesInPackage(aPackage).stream().map(ClassInfo::toString).toList();
            classes.addAll(packageClasses);
        }
        Log.debugf((String)"Package Classes: %s", classes);
        return classes;
    }

    protected List<String> collectInterfacesInPackage(CombinedIndexBuildItem combinedIndex, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<DotName> packages = new ArrayList<DotName>(combinedIndex.getIndex().getSubpackages(packageName));
        packages.add(DotName.createSimple((String)packageName));
        for (DotName aPackage : packages) {
            List<String> packageClasses = combinedIndex.getIndex().getClassesInPackage(aPackage).stream().filter(ClassInfo::isInterface).map(ClassInfo::toString).toList();
            classes.addAll(packageClasses);
        }
        Log.debugf((String)"Package Interfaces: %s", classes);
        return classes;
    }

    protected List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        Log.debugf((String)"Subclasses: %s", classes);
        return classes;
    }

    protected List<String> collectImplementors(CombinedIndexBuildItem combinedIndex, String className) {
        Set classes = combinedIndex.getIndex().getAllKnownImplementors(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toCollection(HashSet::new));
        classes.add(className);
        HashSet<String> subclasses = new HashSet<String>();
        for (String implementationClass : classes) {
            subclasses.addAll(this.collectSubclasses(combinedIndex, implementationClass));
        }
        classes.addAll(subclasses);
        Log.debugf((String)"Implementors: %s", (Object)classes);
        return new ArrayList<String>(classes);
    }
}

