/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.deployment;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.util.GlobUtil;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

@ConfigMapping(prefix="quarkus.jberet")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface JBeretBuildTimeConfig {
    public JobsConfig jobs();

    public static interface JobsConfig {
        public Optional<List<@WithConverter(value=RegexPatternConverter.class) Pattern>> includes();

        public Optional<List<@WithConverter(value=RegexPatternConverter.class) Pattern>> excludes();

        public static class RegexPatternConverter
        implements Converter<Pattern> {
            public Pattern convert(String value) throws IllegalArgumentException, NullPointerException {
                return Pattern.compile(GlobUtil.toRegexPattern((String)value));
            }
        }
    }
}

