/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.deployment;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkiverse.jberet.deployment.BatchArtifactBuildItem;
import io.quarkiverse.jberet.deployment.BatchJobBuildItem;
import io.quarkiverse.jberet.deployment.JBeretBuildTimeConfig;
import io.quarkiverse.jberet.deployment.QuarkusJobXmlResolver;
import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkiverse.jberet.runtime.JBeretConfigSourceFactoryBuilder;
import io.quarkiverse.jberet.runtime.JBeretInMemoryJobRepositoryProducer;
import io.quarkiverse.jberet.runtime.JBeretJdbcJobRepositoryProducer;
import io.quarkiverse.jberet.runtime.JBeretProducer;
import io.quarkiverse.jberet.runtime.JBeretRecorder;
import io.quarkiverse.jberet.runtime.JobsProducer;
import io.quarkiverse.jberet.runtime.QuarkusJobScheduler;
import io.quarkiverse.jberet.runtime.scope.QuarkusJobScopedContextImpl;
import io.quarkiverse.jberet.runtime.scope.QuarkusPartitionScopedContextImpl;
import io.quarkiverse.jberet.runtime.scope.QuarkusStepScopedContextImpl;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.batch.operations.BatchRuntimeException;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.inject.Named;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jberet.cdi.JobScoped;
import org.jberet.cdi.PartitionScoped;
import org.jberet.cdi.StepScoped;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.creation.BatchBeanProducer;
import org.jberet.job.model.BatchArtifacts;
import org.jberet.job.model.Decision;
import org.jberet.job.model.Flow;
import org.jberet.job.model.InheritableJobElement;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Script;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.job.model.Transition;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.spi.JobXmlResolver;
import org.jberet.tools.ChainedJobXmlResolver;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class JBeretProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkiverse.jberet");
    private static final DotName JOB = DotName.createSimple(Job.class);

    @BuildStep
    public void registerExtension(BuildProducer<FeatureBuildItem> feature, BuildProducer<CapabilityBuildItem> capability) {
        feature.produce((BuildItem)new FeatureBuildItem("jberet"));
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem runtimeInitializedDefaultHolder() {
        return new RuntimeInitializedClassBuildItem("org.jberet.spi.JobOperatorContext$DefaultHolder");
    }

    @BuildStep
    public void batchScopes(ContextRegistrationPhaseBuildItem c, BuildProducer<ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem> v) {
        v.produce((BuildItem)new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{c.getContext().configure(JobScoped.class).contextClass(QuarkusJobScopedContextImpl.class), c.getContext().configure(StepScoped.class).contextClass(QuarkusStepScopedContextImpl.class), c.getContext().configure(PartitionScoped.class).contextClass(QuarkusPartitionScopedContextImpl.class)}));
    }

    @BuildStep
    public void config(BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        runTimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(JBeretConfigSourceFactoryBuilder.class.getName()));
    }

    @BuildStep
    public void additionalBeans(JBeretConfig config, CombinedIndexBuildItem combinedIndex, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<BatchArtifactBuildItem> batchArtifact) throws Exception {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{BatchBeanProducer.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JBeretProducer.class}));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{JobsProducer.class}));
        switch (config.repository().type()) {
            case "in-memory": {
                additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JBeretInMemoryJobRepositoryProducer.class));
                break;
            }
            case "jdbc": {
                additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JBeretJdbcJobRepositoryProducer.class));
            }
        }
        final Map<String, String> artifacts = JBeretProcessor.getBatchArtifacts();
        final HashSet<String> unnamedArtifacts = new HashSet<String>();
        for (String artifact : artifacts.keySet()) {
            ClassInfo classInfo = combinedIndex.getIndex().getClassByName(artifact);
            if (classInfo == null) continue;
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)artifact));
            AnnotationInstance namedAnnotation = classInfo.annotation(DotNames.NAMED);
            if (namedAnnotation != null && namedAnnotation.value() != null) continue;
            unnamedArtifacts.add(artifact);
        }
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return AnnotationTarget.Kind.CLASS.equals((Object)kind);
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                String className = context.getTarget().asClass().name().toString();
                if (unnamedArtifacts.contains(className)) {
                    String named = (String)artifacts.get(className);
                    context.transform().add(Named.class, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)named)}).done();
                }
            }
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void validateRepository(JBeretRecorder recorder, JBeretConfig config, BeanDiscoveryFinishedBuildItem beanDiscoveryFinishedBuildItem, List<JdbcDataSourceBuildItem> datasources) {
        switch (config.repository().type()) {
            case "jdbc": {
                String datasource = config.repository().jdbc().datasource();
                if (!datasources.stream().noneMatch(item -> item.getName().equals(datasource))) break;
                throw new ConfigurationException("Datasource name " + datasource + " does not exist. Available datasources: " + datasources.stream().map(JdbcDataSourceBuildItem::getName).collect(Collectors.joining(",")));
            }
            case "in-memory": {
                break;
            }
            default: {
                DotName dotName = DotName.createSimple(JobRepository.class);
                List beanInfos = beanDiscoveryFinishedBuildItem.beanStream().filter(beanInfo -> beanInfo.hasType(dotName) && beanInfo.hasDefaultQualifiers()).collect();
                if (beanInfos.isEmpty()) {
                    throw new ConfigurationException("There is no injectable and @Default JobRepository bean");
                }
                if (beanInfos.size() <= 1) break;
                throw new ConfigurationException("Multiple injectable and @Default JobRepository beans are not allowed : " + String.valueOf(beanInfos));
            }
        }
    }

    @BuildStep
    public void loadJobs(JBeretBuildTimeConfig buildTimeConfig, JBeretConfig config, ValidationPhaseBuildItem validationPhase, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, BuildProducer<BatchJobBuildItem> batchJobs, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) throws Exception {
        ArrayList jobs = new ArrayList();
        HashMap<String, BeanInfo> jobBeans = new HashMap<String, BeanInfo>();
        for (BeanInfo beanInfo : validationPhase.getBeanResolver().resolveBeans(Type.create((DotName)JOB, (Type.Kind)Type.Kind.CLASS), new AnnotationInstance[0])) {
            jobBeans.put(beanInfo.getName(), beanInfo);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ChainedJobXmlResolver jobXmlResolver = new ChainedJobXmlResolver(ServiceLoader.load(JobXmlResolver.class, classLoader), new JobXmlResolver[]{new QuarkusJobXmlResolver(buildTimeConfig, classLoader)});
        for (String jobXmlName : jobXmlResolver.getJobXmlNames(classLoader)) {
            if (jobBeans.containsKey(jobXmlName)) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new AmbiguousResolutionException("Beans: " + String.valueOf(List.of(((BeanInfo)jobBeans.get(jobXmlName)).toString(), "META-INF/batch-jobs/" + jobXmlName + ".xml")))}));
            }
            Job job = ArchiveXmlLoader.loadJobXml((String)jobXmlName, (ClassLoader)classLoader, jobs, (JobXmlResolver)jobXmlResolver);
            job.setJobXmlName(jobXmlName);
            JBeretConfig.JobConfig jobConfig = (JBeretConfig.JobConfig)config.job().get(jobXmlName);
            watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("META-INF/batch-jobs/" + jobXmlName + ".xml"));
            JBeretProcessor.watchJobScripts(job, watchedFiles);
            batchJobs.produce((BuildItem)new BatchJobBuildItem(job, JBeretProcessor.parseCron(job, jobConfig)));
            log.debug((Object)("Processed job with ID " + job.getId() + "  from file " + jobXmlName));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerJobs(RecorderContext recorderContext, JBeretRecorder recorder, JBeretConfig config, List<BatchJobBuildItem> batchJobs, BeanContainerBuildItem beanContainer) throws Exception {
        JBeretProcessor.registerNonDefaultConstructors(recorderContext);
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (BatchJobBuildItem batchJob : batchJobs) {
            jobs.add(batchJob.getJob());
        }
        recorder.registerJobs(jobs, beanContainer.getValue());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem init(JBeretRecorder recorder, JBeretConfig config, ThreadPoolConfig threadPoolConfig, BeanContainerBuildItem beanContainer) {
        recorder.initJobOperator(config, threadPoolConfig, beanContainer.getValue());
        recorder.initScheduler(config);
        return new ServiceStartBuildItem("jberet");
    }

    @BuildStep
    public void nativeImage(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, JBeretConfig config) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"sql/jberet-sql.properties"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"sql/jberet.ddl"}));
        if ("jdbc".equals(config.repository().type())) {
            config.repository().jdbc().ddlFileName().map(String::trim).filter(Predicate.not(String::isEmpty)).ifPresent(v -> resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{v})));
            config.repository().jdbc().sqlFileName().map(String::trim).filter(Predicate.not(String::isEmpty)).ifPresent(v -> resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{v})));
        }
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{QuarkusJobScheduler.class}).methods().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JobInstanceImpl.class}).constructors().methods().fields().build());
        Set<String> serializationClasses = Set.of(Error.class.getName(), Throwable.class.getName(), Exception.class.getName(), RuntimeException.class.getName(), StackTraceElement.class.getName(), BatchRuntimeException.class.getName(), String.class.getName(), "java.util.Collections$EmptyList", "com.oracle.svm.core.jdk.UnsupportedFeatureError");
        for (String serializationClass : serializationClasses) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{serializationClass}).serialization().build());
        }
    }

    private static void registerNonDefaultConstructors(RecorderContext recorderContext) throws Exception {
        recorderContext.registerNonDefaultConstructor(Job.class.getConstructor(String.class), job -> Collections.singletonList(job.getId()));
        recorderContext.registerNonDefaultConstructor(Flow.class.getConstructor(String.class), flow -> Collections.singletonList(flow.getId()));
        recorderContext.registerNonDefaultConstructor(Split.class.getConstructor(String.class), split -> Collections.singletonList(split.getId()));
        recorderContext.registerNonDefaultConstructor(Step.class.getConstructor(String.class), step -> Collections.singletonList(step.getId()));
        recorderContext.registerNonDefaultConstructor(RefArtifact.class.getConstructor(String.class), refArtifact -> Collections.singletonList(refArtifact.getRef()));
        recorderContext.registerNonDefaultConstructor(Decision.class.getConstructor(String.class, String.class), decision -> Stream.of(decision.getId(), decision.getRef()).collect(Collectors.toList()));
        recorderContext.registerNonDefaultConstructor(Transition.class.getConstructor(String.class), transition -> Collections.singletonList(transition.getOn()));
        recorderContext.registerNonDefaultConstructor(Transition.End.class.getConstructor(String.class), end -> Collections.singletonList(end.getOn()));
        recorderContext.registerNonDefaultConstructor(Transition.Fail.class.getConstructor(String.class), fail -> Collections.singletonList(fail.getOn()));
        recorderContext.registerNonDefaultConstructor(Transition.Stop.class.getConstructor(String.class, String.class), stop -> Stream.of(stop.getOn(), stop.getRestart()).collect(Collectors.toList()));
        recorderContext.registerNonDefaultConstructor(Transition.Next.class.getConstructor(String.class), next -> Collections.singletonList(next.getOn()));
        recorderContext.registerNonDefaultConstructor(Script.class.getConstructor(String.class, String.class, String.class), script -> Stream.of(script.getType(), script.getSrc(), script.getSrc() != null ? script.getContent(Thread.currentThread().getContextClassLoader()) : script.getContent()).collect(Collectors.toList()));
    }

    private static String parseCron(Job job, JBeretConfig.JobConfig jobConfig) {
        if (jobConfig == null || jobConfig.cron().isEmpty()) {
            return null;
        }
        try {
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
            Cron cron = parser.parse((String)jobConfig.cron().get());
            cron.validate();
            return (String)jobConfig.cron().get();
        }
        catch (Exception e) {
            throw new ConfigurationException(String.format("The cron expression %s configured in %s is not valid", jobConfig.cron().get(), "quarkus.jberet.job." + job.getJobXmlName() + ".cron"));
        }
    }

    private static Map<String, String> getBatchArtifacts() throws Exception {
        BatchArtifacts batchArtifacts = ArchiveXmlLoader.loadBatchXml((ClassLoader)Thread.currentThread().getContextClassLoader());
        if (batchArtifacts == null) {
            return Collections.emptyMap();
        }
        Field refs = BatchArtifacts.class.getDeclaredField("refs");
        refs.setAccessible(true);
        Map refsToClass = (Map)refs.get(batchArtifacts);
        HashMap<String, String> classToRefs = new HashMap<String, String>();
        for (Map.Entry entry : refsToClass.entrySet()) {
            classToRefs.put((String)entry.getValue(), (String)entry.getKey());
        }
        return classToRefs;
    }

    private static void watchJobScripts(Job job, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        for (JobElement jobElement : job.getJobElements()) {
            JBeretProcessor.watchJobScripts(jobElement, watchedFiles);
        }
        for (InheritableJobElement inheritingJobElement : job.getInheritingJobElements()) {
            JBeretProcessor.watchJobScripts((JobElement)inheritingJobElement, watchedFiles);
        }
    }

    private static void watchJobScripts(JobElement jobElement, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        if (jobElement instanceof Step) {
            Step step = (Step)jobElement;
            JBeretProcessor.watchJobScripts(step.getBatchlet(), watchedFiles);
            if (step.getChunk() != null) {
                JBeretProcessor.watchJobScripts(step.getChunk().getReader(), watchedFiles);
                JBeretProcessor.watchJobScripts(step.getChunk().getProcessor(), watchedFiles);
                JBeretProcessor.watchJobScripts(step.getChunk().getWriter(), watchedFiles);
                JBeretProcessor.watchJobScripts(step.getChunk().getCheckpointAlgorithm(), watchedFiles);
            }
            if (step.getPartition() != null) {
                JBeretProcessor.watchJobScripts(step.getPartition().getMapper(), watchedFiles);
                JBeretProcessor.watchJobScripts(step.getPartition().getCollector(), watchedFiles);
                JBeretProcessor.watchJobScripts(step.getPartition().getAnalyzer(), watchedFiles);
                JBeretProcessor.watchJobScripts(step.getPartition().getReducer(), watchedFiles);
            }
        }
        if (jobElement instanceof Flow) {
            Flow flow = (Flow)jobElement;
            for (JobElement flowElement : flow.getJobElements()) {
                JBeretProcessor.watchJobScripts(flowElement, watchedFiles);
            }
        }
        if (jobElement instanceof Split) {
            Split split = (Split)jobElement;
            for (Flow flow : split.getFlows()) {
                JBeretProcessor.watchJobScripts((JobElement)flow, watchedFiles);
            }
        }
    }

    private static void watchJobScripts(RefArtifact refArtifact, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        if (refArtifact != null && refArtifact.getScript() != null && refArtifact.getScript().getSrc() != null) {
            watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(refArtifact.getScript().getSrc()));
        }
    }
}

