/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.deployment;

import io.quarkiverse.jberet.deployment.JBeretBuildTimeConfig;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jberet.tools.AbstractJobXmlResolver;

public class QuarkusJobXmlResolver
extends AbstractJobXmlResolver {
    private final Set<String> jobXmlNames = new HashSet<String>();

    public QuarkusJobXmlResolver(JBeretBuildTimeConfig config, ClassLoader classLoader) throws IOException {
        ClassPathUtils.consumeAsPaths((ClassLoader)classLoader, (String)"META-INF/batch-jobs/", path -> this.jobXmlNames.addAll(QuarkusJobXmlResolver.findBatchFilesFromPath(path, config)));
    }

    public Collection<String> getJobXmlNames(ClassLoader classLoader) {
        return this.jobXmlNames;
    }

    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        return super.resolveJobXml("META-INF/batch-jobs/" + jobXml, classLoader);
    }

    private static Set<String> findBatchFilesFromPath(Path path, JBeretBuildTimeConfig config) {
        Set<String> set;
        block8: {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                set = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(file -> file.getFileName().toString()).filter(file -> file.endsWith(".xml")).filter(new IncludesFilter(config)).filter(new ExcludesFilter(config)).map(file -> file.substring(0, file.length() - 4)).collect(Collectors.toSet());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptySet();
                }
            }
            walk.close();
        }
        return set;
    }

    private static class IncludesFilter
    implements Predicate<String> {
        private final List<Pattern> includes;

        public IncludesFilter(JBeretBuildTimeConfig config) {
            this.includes = config.jobs().includes().orElse(new ArrayList());
        }

        @Override
        public boolean test(String file) {
            if (this.includes.isEmpty()) {
                return true;
            }
            return this.includes.stream().anyMatch(p -> p.matcher(file).matches());
        }
    }

    private static class ExcludesFilter
    implements Predicate<String> {
        private final List<Pattern> excludes;

        public ExcludesFilter(JBeretBuildTimeConfig config) {
            this.excludes = config.jobs().excludes().orElse(new ArrayList());
        }

        @Override
        public boolean test(String file) {
            if (this.excludes.isEmpty()) {
                return true;
            }
            return this.excludes.stream().noneMatch(p -> p.matcher(file).matches());
        }
    }
}

