/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkus.agroal.runtime.DataSources;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;

public class JBeretJdbcJobRepositoryProducer
implements Supplier<JobRepository> {
    public static final String TYPE = "jdbc";
    @Inject
    JBeretConfig config;
    @Inject
    DataSources dataSources;

    @Override
    @Produces
    @Singleton
    public JobRepository get() {
        Properties configProperties = new Properties();
        this.addJdbcProperty(this.config.repository().jdbc().sqlFileName(), "sql-file", configProperties);
        this.addJdbcProperty(this.config.repository().jdbc().ddlFileName(), "ddl-file", configProperties);
        this.addJdbcProperty(this.config.repository().jdbc().dbTablePrefix(), "db-table-prefix", configProperties);
        this.addJdbcProperty(this.config.repository().jdbc().dbTableSuffix(), "db-table-suffix", configProperties);
        return new JdbcRepository((DataSource)this.dataSources.getDataSource(this.config.repository().jdbc().datasource()), configProperties);
    }

    private void addJdbcProperty(Optional<String> value, String jberetPropertyName, Properties jdbcRepositoryProperties) {
        value.map(String::trim).filter(Predicate.not(String::isEmpty)).ifPresent(v -> jdbcRepositoryProperties.put(jberetPropertyName, v));
    }
}

