/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.jberet.spi.JobOperatorContext;
import org.jberet.util.BatchUtil;

public class JBeretSubstitutions {
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            if (throwable == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return throwable;
    }

    @TargetClass(className="org.jberet.repository.TableColumns")
    static final class Target_TableColumns {
        @Alias
        static int EXECUTION_EXCEPTION_LENGTH_LIMIT = 0;

        Target_TableColumns() {
        }

        @Substitute
        static String formatException(Exception exception) {
            Charset charset;
            if (exception == null) {
                return null;
            }
            Object asString = JBeretSubstitutions.getStackTraceAsString(exception);
            byte[] asBytes = ((String)asString).getBytes(charset = Charset.defaultCharset());
            if (asBytes.length <= EXECUTION_EXCEPTION_LENGTH_LIMIT) {
                return asString;
            }
            asString = exception + BatchUtil.NL + JBeretSubstitutions.getRootCause(exception);
            asBytes = ((String)asString).getBytes(charset);
            if (asBytes.length <= EXECUTION_EXCEPTION_LENGTH_LIMIT) {
                return asString;
            }
            ByteBuffer bb = ByteBuffer.wrap(asBytes, 0, EXECUTION_EXCEPTION_LENGTH_LIMIT);
            CharBuffer cb = CharBuffer.allocate(EXECUTION_EXCEPTION_LENGTH_LIMIT);
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.IGNORE);
            decoder.decode(bb, cb, true);
            decoder.flush(cb);
            return new String(cb.array(), 0, cb.position());
        }
    }

    @TargetClass(value=BatchRuntime.class)
    static final class Target_BatchRuntime {
        Target_BatchRuntime() {
        }

        @Substitute
        public static JobOperator getJobOperator() {
            return JobOperatorContext.getJobOperatorContext().getJobOperator();
        }
    }
}

