/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkus.logging.Log;
import io.quarkus.runtime.ThreadPoolConfig;
import io.smallrye.common.cpu.ProcessorInfo;
import java.util.concurrent.Executor;
import org.jberet.spi.JobExecutor;

class QuarkusJobExecutor
extends JobExecutor {
    private final int maxPoolSize;

    public QuarkusJobExecutor(Executor delegate, ThreadPoolConfig threadPoolConfig, JBeretConfig config) {
        super(delegate);
        this.maxPoolSize = config.maxAsync().map(maxAsync -> {
            if (maxAsync < 1) {
                Log.error((Object)"max-async value must be 1 or greater if set.");
                return null;
            }
            return maxAsync + 1;
        }).orElse(threadPoolConfig.maxThreads.orElse(Math.max(8 * ProcessorInfo.availableProcessors(), 200)));
    }

    protected int getMaximumPoolSize() {
        return this.maxPoolSize;
    }
}

