/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import io.quarkiverse.jberet.runtime.JBeretConfigSource;
import io.quarkiverse.jberet.runtime.JBeretDataHolder;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jberet.job.model.Decision;
import org.jberet.job.model.Flow;
import org.jberet.job.model.InheritableJobElement;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;

public class JBeretConfigSourceFactory
implements ConfigSourceFactory {
    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        HashSet<String> properties = new HashSet<String>();
        List<Job> jobs = JBeretDataHolder.getData().getJobs();
        for (Job job : jobs) {
            JBeretConfigSourceFactory.addConfigNames(properties, (InheritableJobElement)job);
            for (JobElement jobElement : job.getJobElements()) {
                JBeretConfigSourceFactory.addConfigNames(properties, jobElement);
            }
            for (InheritableJobElement inheritingJobElement : job.getInheritingJobElements()) {
                JBeretConfigSourceFactory.addConfigNames(properties, inheritingJobElement);
            }
        }
        return Collections.singletonList(new JBeretConfigSource(properties));
    }

    private static void addConfigNames(Set<String> properties, JobElement jobElement) {
        if (jobElement instanceof Step) {
            Step step = (Step)jobElement;
            JBeretConfigSourceFactory.addConfigNames(properties, (InheritableJobElement)step);
            JBeretConfigSourceFactory.addConfigNames(properties, step.getBatchlet());
            if (step.getChunk() != null) {
                JBeretConfigSourceFactory.addConfigNames(properties, step.getChunk().getReader());
                JBeretConfigSourceFactory.addConfigNames(properties, step.getChunk().getProcessor());
                JBeretConfigSourceFactory.addConfigNames(properties, step.getChunk().getWriter());
                JBeretConfigSourceFactory.addConfigNames(properties, step.getChunk().getCheckpointAlgorithm());
            }
            if (step.getPartition() != null) {
                JBeretConfigSourceFactory.addConfigNames(properties, step.getPartition().getMapper());
                JBeretConfigSourceFactory.addConfigNames(properties, step.getPartition().getCollector());
                JBeretConfigSourceFactory.addConfigNames(properties, step.getPartition().getAnalyzer());
                JBeretConfigSourceFactory.addConfigNames(properties, step.getPartition().getReducer());
            }
        }
        if (jobElement instanceof Flow) {
            Flow flow = (Flow)jobElement;
            JBeretConfigSourceFactory.addConfigNames(properties, (InheritableJobElement)flow);
            for (JobElement flowElement : flow.getJobElements()) {
                JBeretConfigSourceFactory.addConfigNames(properties, flowElement);
            }
        }
        if (jobElement instanceof Split) {
            Split split = (Split)jobElement;
            JBeretConfigSourceFactory.addConfigNames(properties, split.getProperties());
            for (Flow flow : split.getFlows()) {
                JBeretConfigSourceFactory.addConfigNames(properties, (JobElement)flow);
            }
        }
        if (jobElement instanceof Decision) {
            Decision decision = (Decision)jobElement;
            JBeretConfigSourceFactory.addConfigNames(properties, decision.getProperties());
        }
    }

    private static void addConfigNames(Set<String> properties, InheritableJobElement inheritableJobElement) {
        if (inheritableJobElement != null) {
            if (inheritableJobElement.getProperties() != null) {
                JBeretConfigSourceFactory.addConfigNames(properties, inheritableJobElement.getProperties());
            }
            if (inheritableJobElement.getListeners() != null) {
                for (RefArtifact refArtifact : inheritableJobElement.getListeners().getListeners()) {
                    JBeretConfigSourceFactory.addConfigNames(properties, refArtifact);
                }
            }
        }
    }

    private static void addConfigNames(Set<String> properties, RefArtifact refArtifact) {
        if (refArtifact != null && refArtifact.getProperties() != null) {
            JBeretConfigSourceFactory.addConfigNames(properties, refArtifact.getProperties());
        }
    }

    private static void addConfigNames(Set<String> properties, Properties propertiesHolder) {
        if (propertiesHolder != null) {
            properties.addAll(propertiesHolder.getNameValues().keySet());
        }
    }
}

