/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import jakarta.annotation.PostConstruct;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.jberet.job.model.Job;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;

public abstract class AbstractDelegatingJobRepository<T extends JobRepository>
implements JobRepository,
Supplier<T> {
    private T jobRepository;

    @PostConstruct
    private void init() {
        this.jobRepository = (JobRepository)this.get();
    }

    public void addJob(ApplicationAndJobName applicationAndJobName, Job job) {
        this.jobRepository.addJob(applicationAndJobName, job);
    }

    public void removeJob(String jobId) {
        this.jobRepository.removeJob(jobId);
    }

    public Job getJob(ApplicationAndJobName applicationAndJobName) {
        return this.jobRepository.getJob(applicationAndJobName);
    }

    public Set<String> getJobNames() {
        return this.jobRepository.getJobNames();
    }

    public boolean jobExists(String jobName) {
        return this.jobRepository.jobExists(jobName);
    }

    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        return this.jobRepository.createJobInstance(job, applicationName, classLoader);
    }

    public void removeJobInstance(long jobInstanceId) {
        this.jobRepository.removeJobInstance(jobInstanceId);
    }

    public JobInstance getJobInstance(long jobInstanceId) {
        return this.jobRepository.getJobInstance(jobInstanceId);
    }

    public List<JobInstance> getJobInstances(String jobName) {
        return this.jobRepository.getJobInstances(jobName);
    }

    public int getJobInstanceCount(String jobName) {
        return this.jobRepository.getJobInstanceCount(jobName);
    }

    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        return this.jobRepository.createJobExecution(jobInstance, jobParameters);
    }

    public JobExecution getJobExecution(long jobExecutionId) {
        return this.jobRepository.getJobExecution(jobExecutionId);
    }

    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        return this.jobRepository.getJobExecutions(jobInstance);
    }

    public List<Long> getJobExecutionsByJob(String jobName) {
        return this.jobRepository.getJobExecutionsByJob(jobName);
    }

    public List<Long> getJobExecutionsByJob(String jobName, Integer limit) {
        return this.jobRepository.getJobExecutionsByJob(jobName, limit);
    }

    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate, boolean saveJobParameters) {
        this.jobRepository.updateJobExecution(jobExecution, fullUpdate, saveJobParameters);
    }

    public void stopJobExecution(JobExecutionImpl jobExecution) {
        this.jobRepository.stopJobExecution(jobExecution);
    }

    public List<Long> getRunningExecutions(String jobName) {
        return this.jobRepository.getRunningExecutions(jobName);
    }

    public void removeJobExecutions(JobExecutionSelector jobExecutionSelector) {
        this.jobRepository.removeJobExecutions(jobExecutionSelector);
    }

    public List<StepExecution> getStepExecutions(long jobExecutionId, ClassLoader classLoader) {
        return this.jobRepository.getStepExecutions(jobExecutionId, classLoader);
    }

    public StepExecutionImpl createStepExecution(String stepName) {
        return this.jobRepository.createStepExecution(stepName);
    }

    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        this.jobRepository.addStepExecution(jobExecution, stepExecution);
    }

    public void updateStepExecution(StepExecution stepExecution) {
        this.jobRepository.updateStepExecution(stepExecution);
    }

    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart, ClassLoader classLoader) {
        return this.jobRepository.findOriginalStepExecutionForRestart(stepName, jobExecutionToRestart, classLoader);
    }

    public int countStepStartTimes(String stepName, long jobInstanceId) {
        return this.jobRepository.countStepStartTimes(stepName, jobInstanceId);
    }

    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        this.jobRepository.addPartitionExecution(enclosingStepExecution, partitionExecution);
    }

    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly, ClassLoader classLoader) {
        return this.jobRepository.getPartitionExecutions(stepExecutionId, stepExecution, notCompletedOnly, classLoader);
    }

    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        this.jobRepository.savePersistentData(jobExecution, stepOrPartitionExecution);
    }

    public int savePersistentDataIfNotStopping(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
        return this.jobRepository.savePersistentDataIfNotStopping(jobExecution, stepOrPartitionExecution);
    }
}

