/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkiverse.jberet.runtime.JBeretDataHolder;
import io.quarkiverse.jberet.runtime.JobsProducer;
import io.quarkiverse.jberet.runtime.QuarkusBatchEnvironment;
import io.quarkiverse.jberet.runtime.QuarkusJobExecutor;
import io.quarkiverse.jberet.runtime.QuarkusJobOperator;
import io.quarkiverse.jberet.runtime.QuarkusJobScheduler;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.batch.operations.JobOperator;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jberet.job.model.Job;
import org.jberet.repository.JobRepository;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduleConfigBuilder;
import org.jberet.schedule.JobScheduler;
import org.jberet.spi.JobOperatorContext;

@Recorder
public class JBeretRecorder {
    private final JBeretConfig config;
    private final RuntimeValue<ThreadPoolConfig> threadPoolConfig;

    public JBeretRecorder(JBeretConfig config, RuntimeValue<ThreadPoolConfig> threadPoolConfig) {
        this.config = config;
        this.threadPoolConfig = threadPoolConfig;
    }

    public void registerJobs(List<Job> jobs, BeanContainer beanContainer) {
        JobsProducer jobsProducer = (JobsProducer)beanContainer.beanInstance(JobsProducer.class, new Annotation[0]);
        jobs.addAll(jobsProducer.getJobs());
        JBeretDataHolder.registerJobs(jobs);
    }

    public void initJobOperator(BeanContainer beanContainer) {
        ManagedExecutor managedExecutor = (ManagedExecutor)beanContainer.beanInstance(ManagedExecutor.class, new Annotation[0]);
        TransactionManager transactionManager = (TransactionManager)beanContainer.beanInstance(TransactionManager.class, new Annotation[0]);
        JobRepository jobRepository = (JobRepository)beanContainer.beanInstance(JobRepository.class, new Annotation[0]);
        QuarkusJobExecutor quarkusJobExecutor = new QuarkusJobExecutor((Executor)managedExecutor, (ThreadPoolConfig)this.threadPoolConfig.getValue(), this.config);
        JBeretDataHolder.JBeretData data = JBeretDataHolder.getData();
        QuarkusBatchEnvironment batchEnvironment = new QuarkusBatchEnvironment(jobRepository, quarkusJobExecutor, transactionManager, data);
        QuarkusJobOperator operator = new QuarkusJobOperator(this.config, batchEnvironment, data.getJobs());
        JobOperatorContext operatorContext = JobOperatorContext.create((JobOperator)operator);
        JobOperatorContext.setJobOperatorContextSelector(() -> operatorContext);
    }

    public void initScheduler() {
        if (this.config.job().values().stream().noneMatch(jobConfig -> jobConfig.cron().isPresent())) {
            return;
        }
        QuarkusJobScheduler jobScheduler = (QuarkusJobScheduler)JobScheduler.getJobScheduler(QuarkusJobScheduler.class, new ConcurrentHashMap(), null);
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        for (Job job : JBeretDataHolder.getData().getJobs()) {
            JBeretConfig.JobConfig jobConfig2 = this.config.job().get(job.getJobXmlName());
            if (jobConfig2 == null || !jobConfig2.cron().isPresent()) continue;
            Cron cron = parser.parse(jobConfig2.cron().get());
            Properties jobParameters = new Properties();
            if (jobConfig2.params() != null && !jobConfig2.params().isEmpty()) {
                jobParameters.putAll(jobConfig2.params());
            }
            JobScheduleConfig scheduleConfig = JobScheduleConfigBuilder.newInstance().jobName(job.getJobXmlName()).jobParameters(jobParameters).build();
            jobScheduler.schedule(scheduleConfig, cron);
        }
    }
}

