/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jdbc.sqlite.deployment;

import io.quarkiverse.jdbc.sqlite.runtime.SqliteAgroalConnectionConfigurer;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import org.sqlite.JDBC;
import org.sqlite.SQLiteDataSource;

class JDBCSqliteProcessor {
    private static final String FEATURE = "jdbc-sqlite";
    static final String DRIVER_NAME = JDBC.class.getName();
    private static final String DATA_SOURCE_NAME = SQLiteDataSource.class.getName();

    JDBCSqliteProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver, SslNativeConfigBuildItem sslNativeConfigBuildItem) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("sqlite", DRIVER_NAME, DATA_SOURCE_NAME));
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.jdbc((String)"sqlite");
    }

    @BuildStep
    void configureAgroalConnection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(SqliteAgroalConnectionConfigurer.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep
    void registerDefaultDbType(BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("sqlite"));
    }
}

