/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jgit.deployment;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.jgit.deployment.JBossLoggingConsumer;
import io.quarkus.jgit.deployment.JGitBuildTimeConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

class GiteaContainer
extends GenericContainer<GiteaContainer> {
    private static final Logger log = Logger.getLogger(GiteaContainer.class);
    private static final int HTTP_PORT = 3000;
    private JGitBuildTimeConfig.DevService devServiceConfig;
    private List<String> repositories = new ArrayList<String>();

    GiteaContainer(JGitBuildTimeConfig.DevService devServiceConfig) {
        super("gitea/gitea:latest-rootless");
        this.devServiceConfig = devServiceConfig;
        this.withEnv("GITEA__security__INSTALL_LOCK", "true");
        this.withEnv("GITEA__server__DISABLE_SSH", "true");
        this.withExposedPorts(new Integer[]{3000});
        this.withReuse(devServiceConfig.reuse());
        this.waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{3000}));
        this.withStartupAttempts(2);
        devServiceConfig.httpPort().ifPresent(port -> this.addFixedExposedPort(port, 3000));
        if (devServiceConfig.showLogs()) {
            this.withLogConsumer((Consumer)((Object)new JBossLoggingConsumer(log)));
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        if (!reused) {
            try {
                this.createAdminUser();
                for (String repository : this.devServiceConfig.repositories().orElse(Collections.emptyList())) {
                    this.createRepository(this, repository);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to create admin user", e);
            }
        }
    }

    private void createAdminUser() throws IOException, InterruptedException {
        CharSequence[] cmd = new String[]{"/usr/local/bin/gitea", "admin", "user", "create", "--username", this.devServiceConfig.adminUsername(), "--password", this.devServiceConfig.adminPassword(), "--email", "quarkus@quarkus.io", "--must-change-password=false", "--admin"};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = this.execInContainer((String[])cmd);
        log.info((Object)execResult.getStdout());
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("Failed to create admin user: " + execResult.getStderr());
        }
    }

    private void createRepository(GiteaContainer giteaContainer, String repository) throws UnsupportedOperationException, IOException, InterruptedException {
        String httpUrl = "http://localhost:3000";
        String data = "{\"name\":\"%s\", \"private\":false, \"auto_init\":true, \"readme\":\"Default\"}\n".formatted(repository);
        CharSequence[] cmd = new String[]{"/usr/bin/curl", "-X", "POST", "--user", this.devServiceConfig.adminUsername() + ":" + this.devServiceConfig.adminPassword(), "-H", "Content-Type: application/json", "-d", data, httpUrl + "/api/v1/user/repos"};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = giteaContainer.execInContainer((String[])cmd);
        log.info((Object)execResult.getStdout());
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("Failed to create repository: " + repository + ":" + execResult.getStderr());
        }
        this.repositories.add(repository);
        log.info((Object)("Created repository: " + repository));
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getHttpPort();
    }

    public int getHttpPort() {
        return this.getMappedPort(3000);
    }

    public List<String> getRepositories() {
        return this.repositories;
    }
}

