/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jgit.deployment;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

class JBossLoggingConsumer
extends BaseConsumer<JBossLoggingConsumer> {
    private final Logger logger;
    private final Map<String, String> mdc = new HashMap<String, String>();
    private boolean separateOutputStreams;
    private String prefix = "";

    public JBossLoggingConsumer(Logger logger) {
        this(logger, false);
    }

    public JBossLoggingConsumer(Logger logger, boolean separateOutputStreams) {
        this.logger = logger;
        this.separateOutputStreams = separateOutputStreams;
    }

    public JBossLoggingConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    public JBossLoggingConsumer withMdc(String key, String value) {
        this.mdc.put(key, value);
        return this;
    }

    public JBossLoggingConsumer withMdc(Map<String, String> mdc) {
        this.mdc.putAll(mdc);
        return this;
    }

    public JBossLoggingConsumer withSeparateOutputStreams() {
        this.separateOutputStreams = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8StringWithoutLineEnding();
        Map originalMdc = MDC.getMap();
        MDC.clear();
        MDC.getMap().putAll(this.mdc);
        try {
            switch (outputType) {
                case END: {
                    return;
                }
                case STDOUT: {
                    if (this.separateOutputStreams) {
                        this.logger.infof("%s%s", this.prefix.isEmpty() ? "" : this.prefix + ": ", (Object)utf8String);
                        return;
                    } else {
                        this.logger.infof("%s%s: %s", (Object)this.prefix, (Object)outputType, (Object)utf8String);
                        return;
                    }
                }
                case STDERR: {
                    if (this.separateOutputStreams) {
                        this.logger.errorf("%s%s", this.prefix.isEmpty() ? "" : this.prefix + ": ", (Object)utf8String);
                        return;
                    } else {
                        this.logger.infof("%s%s: %s", (Object)this.prefix, (Object)outputType, (Object)utf8String);
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unexpected outputType " + String.valueOf(outputType));
                }
            }
        }
        finally {
            MDC.clear();
            if (originalMdc != null) {
                MDC.getMap().putAll(originalMdc);
            }
        }
    }
}

