/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jgit.deployment;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.quarkus.jgit.deployment.GiteaDevServiceRequestBuildItem;
import io.quarkus.jgit.deployment.JBossLoggingConsumer;
import io.quarkus.jgit.deployment.JGitBuildTimeConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

class GiteaContainer
extends GenericContainer<GiteaContainer> {
    private static final Logger log = Logger.getLogger(GiteaContainer.class);
    static final int HTTP_PORT = 3000;
    private JGitBuildTimeConfig.DevService devServiceConfig;
    private Optional<GiteaDevServiceRequestBuildItem> devServiceRequest;
    private List<String> organizations = new ArrayList<String>();
    private List<String> repositories = new ArrayList<String>();

    GiteaContainer(JGitBuildTimeConfig.DevService devServiceConfig, Optional<GiteaDevServiceRequestBuildItem> devServiceRequest) {
        super("gitea/gitea:latest-rootless");
        this.devServiceConfig = devServiceConfig;
        this.devServiceRequest = devServiceRequest;
        this.withEnv("GITEA__security__INSTALL_LOCK", "true");
        this.withEnv("GITEA__server__DISABLE_SSH", "true");
        this.withExposedPorts(new Integer[]{3000});
        this.withReuse(devServiceConfig.reuse());
        this.waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{3000}));
        this.withStartupAttempts(2);
        Optional<String> networkAlias = devServiceConfig.networkAlias().or(() -> devServiceRequest.map(GiteaDevServiceRequestBuildItem::getAlias));
        networkAlias.ifPresent(alias -> {
            this.withNetworkAliases(new String[]{alias});
            this.withNetwork(Network.SHARED);
        });
        devServiceConfig.httpPort().ifPresent(port -> this.addFixedExposedPort(port, 3000));
        if (devServiceConfig.showLogs()) {
            this.withLogConsumer((Consumer)((Object)new JBossLoggingConsumer(log)));
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        if (!reused) {
            try {
                this.createAdminUser();
                ArrayList organizations = new ArrayList();
                ArrayList repositories = new ArrayList();
                this.devServiceConfig.organizations().ifPresent(o -> organizations.addAll(o));
                this.devServiceConfig.repositories().ifPresent(r -> repositories.addAll(r));
                this.devServiceRequest.map(GiteaDevServiceRequestBuildItem::getOrganizations).ifPresent(o -> organizations.addAll(o));
                this.devServiceRequest.map(GiteaDevServiceRequestBuildItem::getRepositories).ifPresent(r -> repositories.addAll(r));
                for (String org : organizations) {
                    this.createOrganization(org);
                }
                for (String repository : repositories) {
                    this.createRepository(repository);
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to create admin user", e);
            }
        }
    }

    private void createAdminUser() throws IOException, InterruptedException {
        CharSequence[] cmd = new String[]{"/usr/local/bin/gitea", "admin", "user", "create", "--username", this.devServiceConfig.adminUsername(), "--password", this.devServiceConfig.adminPassword(), "--email", "quarkus@quarkus.io", "--must-change-password=false", "--admin"};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = this.execInContainer((String[])cmd);
        log.debug((Object)execResult.getStdout());
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("Failed to create admin user: " + execResult.getStderr());
        }
    }

    private void createOrganization(String org) throws UnsupportedOperationException, IOException, InterruptedException {
        String httpUrl = "http://localhost:3000/api/v1/orgs";
        String data = "{\"username\":\"%s\"}\n".formatted(org);
        CharSequence[] cmd = new String[]{"/usr/bin/curl", "-X", "POST", "--user", this.devServiceConfig.adminUsername() + ":" + this.devServiceConfig.adminPassword(), "-H", "Content-Type: application/json", "-d", data, httpUrl};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = this.execInContainer((String[])cmd);
        log.debug((Object)execResult.getStdout());
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("Failed to create organization: " + org + ":" + execResult.getStderr());
        }
        this.organizations.add(org);
        log.info((Object)("Created organization: " + org));
    }

    private void createRepository(String repository) throws UnsupportedOperationException, IOException, InterruptedException {
        if (repository.contains("/")) {
            String orgName = repository.substring(0, repository.indexOf("/"));
            String repoName = repository.substring(repository.indexOf("/") + 1);
            this.createOrgRepository(orgName, repoName);
        } else {
            this.createUserRepository(repository);
        }
    }

    private void createUserRepository(String repository) throws UnsupportedOperationException, IOException, InterruptedException {
        String httpUrl = "http://localhost:3000/api/v1/user/repos";
        String data = "{\"name\":\"%s\", \"private\":false, \"auto_init\":true, \"readme\":\"Default\"}\n".formatted(repository);
        CharSequence[] cmd = new String[]{"/usr/bin/curl", "-X", "POST", "--user", this.devServiceConfig.adminUsername() + ":" + this.devServiceConfig.adminPassword(), "-H", "Content-Type: application/json", "-d", data, httpUrl};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = this.execInContainer((String[])cmd);
        log.debug((Object)execResult.getStdout());
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("Failed to create repository: " + repository + ":" + execResult.getStderr());
        }
        this.repositories.add(repository);
        log.info((Object)("Created user repository: " + repository));
    }

    private void createOrgRepository(String org, String repository) throws UnsupportedOperationException, IOException, InterruptedException {
        if (!this.organizationExists(org)) {
            this.createOrganization(org);
        }
        String httpUrl = "http://localhost:3000/api/v1/orgs/" + org + "/repos";
        String data = "{\"name\":\"%s\", \"private\":false, \"auto_init\":true, \"readme\":\"Default\"}\n".formatted(repository);
        CharSequence[] cmd = new String[]{"/usr/bin/curl", "-X", "POST", "--user", this.devServiceConfig.adminUsername() + ":" + this.devServiceConfig.adminPassword(), "-H", "Content-Type: application/json", "-d", data, httpUrl};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = this.execInContainer((String[])cmd);
        log.debug((Object)execResult.getStdout());
        if (execResult.getExitCode() != 0) {
            throw new RuntimeException("Failed to create repository: " + repository + ":" + execResult.getStderr());
        }
        this.repositories.add(org + "/" + repository);
        log.info((Object)("Created org repository: " + org + "/" + repository));
    }

    private boolean organizationExists(String org) throws IOException, InterruptedException {
        String httpUrl = "http://localhost:3000/api/v1/orgs/" + org;
        CharSequence[] cmd = new String[]{"/usr/bin/curl", "-X", "GET", "--user", this.devServiceConfig.adminUsername() + ":" + this.devServiceConfig.adminPassword(), "-H", "Content-Type: application/json", httpUrl};
        log.debug((Object)String.join((CharSequence)" ", cmd));
        Container.ExecResult execResult = this.execInContainer((String[])cmd);
        if (execResult.getExitCode() == 0) {
            log.debug((Object)("Organization exists: " + org));
            return true;
        }
        if (execResult.getExitCode() == 404) {
            log.debug((Object)("Organization does not exist: " + org));
            return false;
        }
        throw new RuntimeException("Error checking organization existence: " + execResult.getStderr());
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getHttpPort();
    }

    public int getHttpPort() {
        return this.getMappedPort(3000);
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public List<String> getOrganizations() {
        return this.organizations;
    }
}

