/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jgit.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.jgit.deployment.GiteaContainer;
import io.quarkus.jgit.deployment.GiteaDevServiceInfoBuildItem;
import io.quarkus.jgit.deployment.GiteaDevServiceRequestBuildItem;
import io.quarkus.jgit.deployment.JGitBuildTimeConfig;
import java.io.Closeable;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;

public class JGitDevServicesProcessor {
    private static final Logger log = Logger.getLogger(JGitDevServicesProcessor.class);
    static volatile DevServicesResultBuildItem.RunningDevService devService;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
    DevServicesResultBuildItem createContainer(JGitBuildTimeConfig config, Optional<GiteaDevServiceRequestBuildItem> devServiceRequest, CuratedApplicationShutdownBuildItem closeBuildItem, BuildProducer<GiteaDevServiceInfoBuildItem> giteaServiceInfo) {
        if (devService != null) {
            return null;
        }
        if (!config.devservices().enabled() && !devServiceRequest.isPresent()) {
            return null;
        }
        GiteaContainer gitServer = new GiteaContainer(config.devservices(), devServiceRequest);
        gitServer.start();
        String httpUrl = gitServer.getHttpUrl();
        log.infof("Gitea HTTP URL: %s", (Object)httpUrl);
        Map<String, String> configOverrides = Map.of("quarkus.jgit.devservices.http-url", httpUrl);
        Optional<String> sharedNetworkHost = config.devservices().networkAlias().or(() -> devServiceRequest.map(GiteaDevServiceRequestBuildItem::getAlias));
        OptionalInt sharedNetworkHttpPort = OptionalInt.of(3000);
        ContainerShutdownCloseable closeable = new ContainerShutdownCloseable((GenericContainer)gitServer, "jgit");
        closeBuildItem.addCloseTask(() -> ((ContainerShutdownCloseable)closeable).close(), true);
        devService = new DevServicesResultBuildItem.RunningDevService("jgit", gitServer.getContainerId(), (Closeable)closeable, configOverrides);
        giteaServiceInfo.produce((BuildItem)new GiteaDevServiceInfoBuildItem(gitServer.getHost(), gitServer.getHttpPort(), sharedNetworkHost, sharedNetworkHttpPort, config.devservices().adminUsername(), config.devservices().adminPassword(), gitServer.getOrganizations(), gitServer.getRepositories()));
        return devService.toBuildItem();
    }
}

