/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jgit.deployment.devui;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.jgit.deployment.GiteaDevServiceInfoBuildItem;
import java.util.Optional;
import org.eclipse.jgit.api.Git;

public class GiteaDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    void createCard(Optional<GiteaDevServiceInfoBuildItem> info, BuildProducer<CardPageBuildItem> cardPage) {
        CardPageBuildItem card = new CardPageBuildItem();
        info.ifPresent(i -> {
            String url = "http://" + i.host() + ":" + i.httpPort();
            card.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Gitea Dashboard").doNotEmbed().icon("font-awesome-solid:code-branch")).url(url, url));
        });
        ExternalPageBuilder versionPage = (ExternalPageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"JGit Version").icon("font-awesome-solid:tag")).url("https://www.eclipse.org/jgit/").doNotEmbed().staticLabel(Git.class.getPackage().getImplementationVersion());
        card.addPage((PageBuilder)versionPage);
        card.setCustomCard("qwc-jgit-card.js");
        cardPage.produce((BuildItem)card);
    }
}

