/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jooq.runtime;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceMetrics;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Provider;
import org.jboss.logging.Logger;

public class ConnectionProvider
implements Provider<Connection> {
    private static final Logger LOGGER = Logger.getLogger(ConnectionProvider.class);
    private final AgroalDataSource dataSource;

    public ConnectionProvider(AgroalDataSource dataSource) {
        this.dataSource = dataSource;
        this.dataSource.getConfiguration().setMetricsEnabled(true);
    }

    public Connection get() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            AgroalDataSourceMetrics metrics = this.dataSource.getMetrics();
            this.debugMetrics(metrics, e.getMessage());
            LOGGER.error((Object)("Error occurred and metrics: " + this.dataSource.getMetrics()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void debugMetrics(AgroalDataSourceMetrics metrics, String prefix) {
        long maxUsedCount = metrics.maxUsedCount();
        LOGGER.tracev(prefix + " maxUsedCount: {0}, activeCount: {1}, availableCount: {2}", (Object)(maxUsedCount == Long.MIN_VALUE ? -1L : maxUsedCount), (Object)metrics.activeCount(), (Object)metrics.availableCount());
    }
}

