/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jpastreamer.deployment;

import com.speedment.jpastreamer.analytics.AnalyticsReporterFactory;
import com.speedment.jpastreamer.announcer.Announcer;
import com.speedment.jpastreamer.appinfo.ApplicationInformation;
import com.speedment.jpastreamer.application.JPAStreamerBuilderFactory;
import com.speedment.jpastreamer.autoclose.AutoCloseFactory;
import com.speedment.jpastreamer.builder.BuilderFactory;
import com.speedment.jpastreamer.criteria.CriteriaFactory;
import com.speedment.jpastreamer.criteria.OrderFactory;
import com.speedment.jpastreamer.criteria.PredicateFactory;
import com.speedment.jpastreamer.exception.JPAStreamerException;
import com.speedment.jpastreamer.interopoptimizer.IntermediateOperationOptimizerFactory;
import com.speedment.jpastreamer.merger.MergerFactory;
import com.speedment.jpastreamer.pipeline.PipelineFactory;
import com.speedment.jpastreamer.pipeline.intermediate.DoubleIntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.IntIntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.LongIntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.DoubleTerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.IntTerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.LongTerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationFactory;
import com.speedment.jpastreamer.renderer.RendererFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfigurationFactory;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.util.Set;

class JPAStreamerProcessor {
    private static final String FEATURE = "jpastreamer";

    JPAStreamerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void checkpointHibernateOrm(Capabilities capabilities, BuildProducer<NativeImageResourceBuildItem> jpaModelPersistenceUnitMapping, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        if (capabilities.isMissing("io.quarkus.hibernate.orm")) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new JPAStreamerException("JPAStreamer requires the presence of a JPA provider.")}));
        }
    }

    @BuildStep
    void registerServiceProviders(BuildProducer<NativeImageResourceBuildItem> nativeResource, BuildProducer<ServiceProviderBuildItem> services) throws IOException {
        this.registerServiceProviders(AnalyticsReporterFactory.class, nativeResource, services);
        this.registerServiceProviders(Announcer.class, nativeResource, services);
        this.registerServiceProviders(ApplicationInformation.class, nativeResource, services);
        this.registerServiceProviders(AutoCloseFactory.class, nativeResource, services);
        this.registerServiceProviders(BuilderFactory.class, nativeResource, services);
        this.registerServiceProviders(CriteriaFactory.class, nativeResource, services);
        this.registerServiceProviders(DoubleIntermediateOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(DoubleTerminalOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(IntermediateOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(IntermediateOperationOptimizerFactory.class, nativeResource, services);
        this.registerServiceProviders(IntIntermediateOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(IntTerminalOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(JPAStreamerBuilderFactory.class, nativeResource, services);
        this.registerServiceProviders(LongIntermediateOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(LongTerminalOperationFactory.class, nativeResource, services);
        this.registerServiceProviders(MergerFactory.class, nativeResource, services);
        this.registerServiceProviders(OrderFactory.class, nativeResource, services);
        this.registerServiceProviders(PipelineFactory.class, nativeResource, services);
        this.registerServiceProviders(PredicateFactory.class, nativeResource, services);
        this.registerServiceProviders(RendererFactory.class, nativeResource, services);
        this.registerServiceProviders(StreamConfigurationFactory.class, nativeResource, services);
        this.registerServiceProviders(TerminalOperationFactory.class, nativeResource, services);
    }

    void registerServiceProviders(Class<?> klass, BuildProducer<NativeImageResourceBuildItem> nativeResource, BuildProducer<ServiceProviderBuildItem> services) throws IOException {
        String service = "META-INF/services/" + klass.getName();
        Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
        services.produce((BuildItem)new ServiceProviderBuildItem(klass.getName(), implementations.toArray(new String[0])));
        nativeResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{service}));
    }
}

