/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.api.serdes;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class JacksonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> targetClass;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer(Class<T> targetClass) {
        this(targetClass, new ObjectMapper());
    }

    public T deserialize(String s, byte[] bytes) {
        return this.deserialize(s, null, bytes);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        Object pojo;
        if (data == null) {
            return null;
        }
        try {
            pojo = this.objectMapper.readValue(data, this.targetClass);
        }
        catch (Exception e) {
            throw new SerializationException("Error deserializing JSON message into Pojo object", (Throwable)e);
        }
        return (T)pojo;
    }

    @Generated
    public JacksonDeserializer(Class<T> targetClass, ObjectMapper objectMapper) {
        this.targetClass = targetClass;
        this.objectMapper = objectMapper;
    }
}

