/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.api.serdes;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.kafkastreamsprocessor.api.serdes.JacksonDeserializer;
import io.quarkiverse.kafkastreamsprocessor.api.serdes.JacksonSerializer;
import lombok.Generated;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public class JacksonSerde<T>
implements Serde<T> {
    private final Class<T> targetClass;
    private final ObjectMapper objectMapper;

    public JacksonSerde(Class<T> targetClass) {
        this(targetClass, new ObjectMapper());
    }

    public Serializer<T> serializer() {
        return new JacksonSerializer(this.objectMapper);
    }

    public Deserializer<T> deserializer() {
        return new JacksonDeserializer<T>(this.targetClass, this.objectMapper);
    }

    @Generated
    public JacksonSerde(Class<T> targetClass, ObjectMapper objectMapper) {
        this.targetClass = targetClass;
        this.objectMapper = objectMapper;
    }
}

