/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.api.serdes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class JacksonSerializer<T>
implements Serializer<T> {
    private final ObjectMapper objectMapper;

    public JacksonSerializer() {
        this(new ObjectMapper());
    }

    public byte[] serialize(String topic, T myPojo) {
        return this.serialize(topic, null, myPojo);
    }

    public byte[] serialize(String topic, Headers headers, T myPojo) {
        if (myPojo == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsBytes(myPojo);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Error serializing Pojo object into bytes", (Throwable)e);
        }
    }

    @Generated
    public JacksonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

