/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.kafka.streams.deployment;

import io.quarkiverse.kafkastreamsprocessor.api.Processor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class KafkaStreamsProcessorProcessor {
    private static final String FEATURE = "kafka-streams-processor";
    private static final DotName PROCESSOR_ANNOTATION = DotName.createSimple((String)Processor.class.getName());

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void configureNativeExecutable(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        for (AnnotationInstance processor : combinedIndex.getIndex().getAnnotations(PROCESSOR_ANNOTATION)) {
            AnnotationTarget target = processor.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{target.asClass().name().toString()}).constructors().methods().fields().build());
        }
    }

    @BuildStep
    public void registerRetryExceptions(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        Config config = ConfigProvider.getConfig();
        config.getOptionalValue("kafkastreamsprocessor.retry.retry-on", String[].class).ifPresent(retryExceptions -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])retryExceptions).methods(false).fields(false).build()));
        config.getOptionalValue("kafkastreamsprocessor.retry.abort-on", String[].class).ifPresent(abortExceptions -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])abortExceptions).methods(false).fields(false).build()));
    }
}

