/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl;

import io.quarkiverse.kafkastreamsprocessor.spi.properties.KStreamsProcessorConfig;
import io.quarkiverse.kafkastreamsprocessor.spi.properties.SinkConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SinkToTopicMappingBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SinkToTopicMappingBuilder.class);
    String DEFAULT_SINK_NAME = "emitter-channel";
    private final KStreamsProcessorConfig extensionConfiguration;

    @Inject
    public SinkToTopicMappingBuilder(KStreamsProcessorConfig extensionConfiguration) {
        this.extensionConfiguration = extensionConfiguration;
    }

    public Map<String, String> sinkToTopicMapping() {
        Optional singleOutputTopic;
        Map<String, String> sinkToTopicMapping = this.buildMapping();
        if (sinkToTopicMapping.isEmpty() && (singleOutputTopic = this.extensionConfiguration.output().topic()).isPresent()) {
            return Map.of(this.DEFAULT_SINK_NAME, (String)singleOutputTopic.get());
        }
        return sinkToTopicMapping;
    }

    private Map<String, String> buildMapping() {
        HashMap<String, String> sinkToTopicMapping = new HashMap<String, String>();
        for (Map.Entry sinkEntry : this.extensionConfiguration.output().sinks().entrySet()) {
            String topicName = ((SinkConfig)sinkEntry.getValue()).topic();
            if (topicName == null || topicName.isEmpty()) continue;
            sinkToTopicMapping.put((String)sinkEntry.getKey(), topicName);
        }
        return sinkToTopicMapping;
    }
}

