/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.configuration;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.quarkiverse.kafkastreamsprocessor.api.Processor;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.stream.Stream;

public final class TypeUtils {
    private TypeUtils() {
    }

    static Parser<MessageLite> createParserFromType(Class<?> protobufMessageType) {
        try {
            if (GeneratedMessageV3.class.isAssignableFrom(protobufMessageType)) {
                return (Parser)protobufMessageType.getMethod("parser", new Class[0]).invoke(null, new Object[0]);
            }
            throw new IllegalArgumentException("Payload type " + protobufMessageType + " can not assigned to " + GeneratedMessageV3.class);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot instantiate a parser from type " + protobufMessageType, e);
        }
    }

    public static Class<?> reifiedProcessorType(BeanManager beanManager) {
        TypeLiteral kafka2ProcessorType = new TypeLiteral<org.apache.kafka.streams.processor.Processor<?, ?>>(){};
        TypeLiteral kafka3ProcessorType = new TypeLiteral<org.apache.kafka.streams.processor.api.Processor<?, ?, ?, ?>>(){};
        return Stream.concat(beanManager.getBeans(kafka2ProcessorType.getType(), new Annotation[0]).stream(), beanManager.getBeans(kafka3ProcessorType.getType(), new Annotation[0]).stream()).filter(b -> b.getStereotypes().contains(Processor.class)).findFirst().orElseThrow(() -> TypeUtils.lambda$reifiedProcessorType$1((TypeLiteral)kafka2ProcessorType, (TypeLiteral)kafka3ProcessorType)).getBeanClass();
    }

    public static Class<?> extractPayloadType(Type type) {
        Class<?> payloadType;
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length >= 2) {
            return TypeFactory.rawClass((Type)((ParameterizedType)type).getActualTypeArguments()[1]);
        }
        Class clazz = TypeFactory.rawClass((Type)type);
        if (clazz.getGenericSuperclass() != null && (payloadType = TypeUtils.extractPayloadType(clazz.getGenericSuperclass())) != null) {
            return payloadType;
        }
        for (Type interfaceType : clazz.getGenericInterfaces()) {
            Class<?> payloadType2 = TypeUtils.extractPayloadType(interfaceType);
            if (payloadType2 == null) continue;
            return payloadType2;
        }
        return null;
    }

    private static /* synthetic */ IllegalArgumentException lambda$reifiedProcessorType$1(TypeLiteral kafka2ProcessorType, TypeLiteral kafka3ProcessorType) {
        return new IllegalArgumentException("No bean found of type either " + kafka2ProcessorType.getType() + " or " + kafka3ProcessorType.getType());
    }
}

