/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkiverse.kafkastreamsprocessor.impl.metrics.KafkaStreamsProcessorMetrics;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;

@Decorator
@Priority(value=400)
public class MetricsDecorator<KIn, VIn, KOut, VOut>
implements Processor<KIn, VIn, KOut, VOut> {
    private final Processor<KIn, VIn, KOut, VOut> delegate;
    private final KafkaStreamsProcessorMetrics metrics;

    @Inject
    public MetricsDecorator(@Delegate Processor<KIn, VIn, KOut, VOut> delegate, KafkaStreamsProcessorMetrics metrics) {
        this.delegate = delegate;
        this.metrics = metrics;
    }

    public void process(Record<KIn, VIn> record) {
        try {
            this.delegate.process(record);
        }
        catch (Exception e) {
            this.metrics.processorErrorCounter().increment();
            throw e;
        }
    }

    @Generated
    public void init(ProcessorContext<KOut, VOut> context) {
        this.delegate.init(context);
    }

    @Generated
    public void close() {
        this.delegate.close();
    }

    private static interface Excludes {
        public <KIn, VIn> void process(Record<KIn, VIn> var1);
    }
}

