/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor;

import io.quarkiverse.kafkastreamsprocessor.impl.decorator.processor.RetryDecoratorDelegate;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Decorator
@Priority(value=600)
public class RetryDecorator<KIn, VIn, KOut, VOut>
implements Processor<KIn, VIn, KOut, VOut> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryDecorator.class);
    private final Processor<KIn, VIn, KOut, VOut> delegate;
    private final RetryDecoratorDelegate retryDecoratorDelegate;

    @Inject
    public RetryDecorator(@Delegate Processor<KIn, VIn, KOut, VOut> delegate, RetryDecoratorDelegate retryDecoratorDelegate) {
        this.delegate = delegate;
        this.retryDecoratorDelegate = retryDecoratorDelegate;
    }

    public void process(Record<KIn, VIn> record) {
        try {
            this.retryDecoratorDelegate.retryableProcess(this.delegate, record);
        }
        catch (RuntimeException e) {
            log.info("An exception that has been raised by the processor will not be retried.\nPossible causes:\n- That's not a managed retryable exception\n- max-retries or max-duration limits have been reached");
            throw e;
        }
    }

    @Generated
    public void init(ProcessorContext<KOut, VOut> context) {
        this.delegate.init(context);
    }

    @Generated
    public void close() {
        this.delegate.close();
    }

    private static interface Excludes {
        public <KIn, VIn> void process(Record<KIn, VIn> var1);
    }
}

