/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.punctuator;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.punctuator.DecoratedPunctuator;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.kafka.streams.processor.Punctuator;

@Decorator
@Priority(value=100)
public class CdiRequestContextPunctuatorDecorator
implements DecoratedPunctuator {
    private final DecoratedPunctuator delegate;
    private final ArcContainer container;

    @Inject
    public CdiRequestContextPunctuatorDecorator(@Delegate DecoratedPunctuator delegate) {
        this(delegate, Arc.container());
    }

    public void punctuate(long timestamp) {
        if (this.container.requestContext().isActive()) {
            this.delegate.punctuate(timestamp);
        } else {
            this.container.requestContext().activate();
            try {
                this.delegate.punctuate(timestamp);
            }
            finally {
                this.container.requestContext().terminate();
            }
        }
    }

    @Generated
    CdiRequestContextPunctuatorDecorator(DecoratedPunctuator delegate, ArcContainer container) {
        this.delegate = delegate;
        this.container = container;
    }

    @Generated
    public void setRealPunctuatorInstance(Punctuator realPunctuatorInstance) {
        this.delegate.setRealPunctuatorInstance(realPunctuatorInstance);
    }

    private static interface Excludes {
        public void punctuate(long var1);
    }
}

