/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.decorator.punctuator;

import io.quarkiverse.kafkastreamsprocessor.api.decorator.punctuator.DecoratedPunctuator;
import io.quarkiverse.kafkastreamsprocessor.impl.metrics.KafkaStreamsProcessorMetrics;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.kafka.streams.processor.Punctuator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Decorator
@Priority(value=200)
public class MetricsPunctuatorDecorator
implements DecoratedPunctuator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsPunctuatorDecorator.class);
    private final DecoratedPunctuator delegate;
    private final KafkaStreamsProcessorMetrics metrics;

    @Inject
    public MetricsPunctuatorDecorator(@Delegate DecoratedPunctuator delegate, KafkaStreamsProcessorMetrics metrics) {
        this.delegate = delegate;
        this.metrics = metrics;
    }

    public void punctuate(long timestamp) {
        try {
            this.delegate.punctuate(timestamp);
        }
        catch (Exception e) {
            log.error("Exception raised during punctuate", (Throwable)e);
            this.metrics.punctuatorErrorCounter().increment();
        }
    }

    @Generated
    public void setRealPunctuatorInstance(Punctuator realPunctuatorInstance) {
        this.delegate.setRealPunctuatorInstance(realPunctuatorInstance);
    }

    private static interface Excludes {
        public void punctuate(long var1);
    }
}

