/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import lombok.Generated;

@ApplicationScoped
public class KafkaStreamsProcessorMetrics {
    private final Counter processorErrorCounter;
    private final Counter microserviceDlqSentCounter;
    private final Counter globalDlqSentCounter;
    private final Counter punctuatorErrorCounter;

    @Inject
    public KafkaStreamsProcessorMetrics(MeterRegistry registry) {
        this.processorErrorCounter = Counter.builder((String)"kafkastreamsprocessor.processor.errors").description("Total number of errors encountered during Kafka Streams message processing").register(registry);
        this.microserviceDlqSentCounter = Counter.builder((String)"kafkastreamsprocessor.dlq.sent").description("Total number of messages sent to DLQ").register(registry);
        this.globalDlqSentCounter = Counter.builder((String)"kafkastreamsprocessor.global.dlq.sent").description("Counts messages sent to a dead letter queue global to the entire application (cross microservice, i.e. eventually containing messages of different types)").register(registry);
        this.punctuatorErrorCounter = Counter.builder((String)"kafkastreamsprocessor.punctuation.errors").description("Total number of exception caught and recorded of all the configured Punctuator implementations").register(registry);
    }

    @Generated
    public Counter processorErrorCounter() {
        return this.processorErrorCounter;
    }

    @Generated
    public Counter microserviceDlqSentCounter() {
        return this.microserviceDlqSentCounter;
    }

    @Generated
    public Counter globalDlqSentCounter() {
        return this.globalDlqSentCounter;
    }

    @Generated
    public Counter punctuatorErrorCounter() {
        return this.punctuatorErrorCounter;
    }
}

