/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.kafkastreamsprocessor.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.MessageLite;
import jakarta.inject.Inject;
import org.apache.kafka.common.serialization.Serializer;

public class IntrospectionSerializer
implements Serializer<Object> {
    private final ObjectMapper objectMapper;

    @Inject
    public IntrospectionSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] serialize(String topic, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof MessageLite) {
            return ((MessageLite)data).toByteArray();
        }
        return this.serializeAsJson(data);
    }

    private byte[] serializeAsJson(Object data) {
        try {
            return this.objectMapper.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Message cannot be processed, one of the following payloads is expected: valid JSON Pojo or Protobuf", e);
        }
    }
}

